/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.portlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.URLBuilder;
import juzu.impl.request.spi.MimeBridge;
import juzu.impl.request.spi.portlet.PortletBridgeContext;
import juzu.impl.request.spi.portlet.PortletRequestBridge;
import juzu.io.AppendableStream;
import juzu.io.BinaryOutputStream;
import juzu.io.Stream;
import juzu.portlet.JuzuPortlet;
import juzu.request.Phase;
import juzu.request.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PortletMimeBridge<Rq extends PortletRequest, Rs extends MimeResponse>
extends PortletRequestBridge<Rq, Rs>
implements MimeBridge {
    private String mimeType;
    private Object result;
    private final boolean buffer;

    PortletMimeBridge(PortletBridgeContext context, Rq request, Rs response, boolean buffer, boolean prod) {
        super(context, request, response, prod);
        this.buffer = buffer;
    }

    public void commit() throws IOException {
        if (this.result != null) {
            if (this.mimeType != null) {
                ((MimeResponse)this.resp).setContentType(this.mimeType);
            }
            if (this.result instanceof String) {
                ((MimeResponse)this.resp).getWriter().write((String)this.result);
            } else {
                ((MimeResponse)this.resp).getPortletOutputStream().write((byte[])this.result);
            }
        }
    }

    @Override
    public <T> String checkPropertyValidity(Phase phase, PropertyType<T> propertyType, T propertyValue) {
        if (propertyType == JuzuPortlet.PORTLET_MODE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have portlet modes";
            }
            PortletMode portletMode = (PortletMode)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedPortletModes();
            while (e.hasMoreElements()) {
                PortletMode next = (PortletMode)e.nextElement();
                if (!next.equals((Object)portletMode)) continue;
                return null;
            }
            return "Unsupported portlet mode " + portletMode;
        }
        if (propertyType == JuzuPortlet.WINDOW_STATE) {
            if (phase == Phase.RESOURCE) {
                return "Resource URL don't have windwo state";
            }
            WindowState windowState = (WindowState)propertyValue;
            Enumeration e = this.req.getPortalContext().getSupportedWindowStates();
            while (e.hasMoreElements()) {
                WindowState next = (WindowState)e.nextElement();
                if (!next.equals((Object)windowState)) continue;
                return null;
            }
            return "Unsupported window state " + windowState;
        }
        return null;
    }

    @Override
    public String renderURL(Phase phase, Map<String, String[]> parameters, PropertyMap properties) {
        PortletURL url;
        switch (phase) {
            case ACTION: {
                url = ((MimeResponse)this.resp).createActionURL();
                break;
            }
            case RENDER: {
                url = ((MimeResponse)this.resp).createRenderURL();
                break;
            }
            case RESOURCE: {
                url = ((MimeResponse)this.resp).createResourceURL();
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected phase " + (Object)((Object)phase)));
            }
        }
        url.setParameters(parameters);
        boolean escapeXML = false;
        if (properties != null) {
            String methodId;
            WindowState windowStateProperty;
            PortletMode portletModeProperty;
            Boolean escapeXMLProperty = properties.getValue(URLBuilder.ESCAPE_XML);
            if (escapeXMLProperty != null && Boolean.TRUE.equals(escapeXMLProperty)) {
                escapeXML = true;
            }
            if ((portletModeProperty = properties.getValue(JuzuPortlet.PORTLET_MODE)) != null) {
                if (url instanceof PortletURL) {
                    try {
                        url.setPortletMode(portletModeProperty);
                    }
                    catch (PortletModeException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if ((windowStateProperty = properties.getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                if (url instanceof PortletURL) {
                    try {
                        url.setWindowState(windowStateProperty);
                    }
                    catch (WindowStateException e) {
                        throw new IllegalArgumentException(e);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
            if ((methodId = properties.getValue(RequestContext.METHOD_ID)) != null) {
                url.setParameter("juzu.op", methodId);
            }
        }
        if (escapeXML) {
            try {
                StringWriter writer = new StringWriter();
                url.write((Writer)writer, true);
                return writer.toString();
            }
            catch (IOException ignore) {
                return "";
            }
        }
        return url.toString();
    }

    @Override
    public void end(Response response) throws IllegalStateException, IOException {
        if (response instanceof Response.Content) {
            Response.Content content = (Response.Content)response;
            String mimeType = content.getMimeType();
            if (mimeType != null) {
                if (this.buffer) {
                    this.mimeType = mimeType;
                } else {
                    ((MimeResponse)this.resp).setContentType(mimeType);
                }
            }
            if (content.getKind() == Stream.Char.class) {
                if (this.buffer) {
                    StringBuilder sb = new StringBuilder();
                    AppendableStream stream = new AppendableStream(sb);
                    ((Response.Content)response).send(stream);
                    this.result = sb.toString();
                } else {
                    ((Response.Content)response).send(new AppendableStream(((MimeResponse)this.resp).getWriter()));
                }
            } else if (this.buffer) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BinaryOutputStream stream = new BinaryOutputStream(baos);
                ((Response.Content)response).send(stream);
                this.result = baos.toByteArray();
            } else {
                ((Response.Content)response).send(new BinaryOutputStream(((MimeResponse)this.resp).getPortletOutputStream()));
            }
        }
    }
}

