/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.servlet;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import juzu.impl.application.ApplicationContext;
import juzu.impl.asset.AssetManager;
import juzu.impl.request.spi.servlet.ServletActionBridge;
import juzu.impl.request.spi.servlet.ServletRenderBridge;
import juzu.impl.request.spi.servlet.ServletRequestBridge;
import juzu.impl.request.spi.servlet.ServletResourceBridge;
import juzu.impl.utils.Logger;
import juzu.request.Phase;

public class ServletBridgeContext {
    final ApplicationContext application;
    final AssetManager scriptManager;
    final AssetManager stylesheetManager;
    final Logger log;

    public ServletBridgeContext(ApplicationContext application, AssetManager scriptManager, AssetManager stylesheetManager, Logger log) {
        this.application = application;
        this.scriptManager = scriptManager;
        this.stylesheetManager = stylesheetManager;
        this.log = log;
    }

    public ApplicationContext getApplication() {
        return this.application;
    }

    public AssetManager getScriptManager() {
        return this.scriptManager;
    }

    public AssetManager getStylesheetManager() {
        return this.stylesheetManager;
    }

    public Logger getLog() {
        return this.log;
    }

    public ServletRequestBridge create(HttpServletRequest req, HttpServletResponse resp) {
        Phase phase = Phase.RENDER;
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        String methodId = null;
        for (Map.Entry entry : req.getParameterMap().entrySet()) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (name.equals("juzu.phase")) {
                phase = Phase.valueOf(value[0]);
                continue;
            }
            if (name.equals("juzu.op")) {
                methodId = value[0];
                continue;
            }
            parameters.put(name, value);
        }
        switch (phase) {
            case RENDER: {
                return new ServletRenderBridge(this, req, resp, methodId, parameters);
            }
            case ACTION: {
                return new ServletActionBridge(this, req, resp, methodId, parameters);
            }
            case RESOURCE: {
                return new ServletResourceBridge(this, req, resp, methodId, parameters);
            }
        }
        throw new UnsupportedOperationException("todo");
    }
}

