/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.controller.metamodel.ControllerMetaModel;
import juzu.impl.controller.metamodel.ControllerMethodMetaModel;
import juzu.impl.controller.metamodel.ControllersMetaModel;
import juzu.impl.controller.metamodel.ParameterMetaModel;
import juzu.impl.template.metamodel.TemplateMetaModel;
import juzu.impl.template.metamodel.TemplatesMetaModel;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.TemplateProvider;
import juzu.impl.utils.Content;
import juzu.impl.utils.MethodInvocation;
import juzu.impl.utils.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ModelTemplateProcessContext
extends ProcessContext {
    private TemplateMetaModel templateMetaModel;
    private final ProcessingContext env;

    ModelTemplateProcessContext(TemplateMetaModel templateMetaModel, Map<Path, Template<?>> templates, ProcessingContext env) {
        super(templates);
        this.templateMetaModel = templateMetaModel;
        this.env = env;
    }

    Collection<Template<?>> resolve(final TemplateMetaModel metaModel) {
        ElementHandle.Field handle = this.templateMetaModel.getRefs().iterator().next().getHandle();
        return (Collection)this.env.executeWithin(handle, new Callable<Collection<Template<?>>>(){

            @Override
            public Collection<Template<?>> call() throws Exception {
                HashSet keys = new HashSet(ModelTemplateProcessContext.this.templates.keySet());
                ModelTemplateProcessContext.this.resolveTemplate(metaModel.getPath());
                HashMap copy = new HashMap(ModelTemplateProcessContext.this.templates);
                copy.keySet().removeAll(keys);
                return copy.values();
            }
        });
    }

    @Override
    protected TemplateProvider resolverProvider(String ext) {
        return this.templateMetaModel.getTemplates().plugin.providers.get(ext);
    }

    @Override
    public MethodInvocation resolveMethodInvocation(String typeName, String methodName, Map<String, String> parameterMap) throws CompilationException {
        ControllerMethodMetaModel method = this.templateMetaModel.getTemplates().getApplication().getChild(ControllersMetaModel.KEY).resolve(typeName, methodName, parameterMap.keySet());
        if (method == null) {
            throw ControllerMetaModel.CONTROLLER_METHOD_NOT_RESOLVED.failure(methodName + "(" + parameterMap + ")");
        }
        ArrayList<String> args = new ArrayList<String>();
        for (ParameterMetaModel param : method.getParameters()) {
            String value = parameterMap.get(param.getName());
            args.add(value);
        }
        return new MethodInvocation(method.getController().getHandle().getFQN().getName() + "_", method.getName() + "URL", args);
    }

    @Override
    protected Content resolveResource(Path path) {
        TemplatesMetaModel tmm = this.templateMetaModel.getTemplates();
        ElementHandle.Package context = tmm.getApplication().getHandle();
        return this.env.resolveResource(context, tmm.resolve(path));
    }
}

