/*
 * Decompiled with CFR 0.152.
 */
package juzu.portlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.ResourceServingPortlet;
import javax.portlet.WindowState;
import juzu.PropertyType;
import juzu.impl.application.ApplicationException;
import juzu.impl.application.ApplicationRuntime;
import juzu.impl.asset.AssetServer;
import juzu.impl.compiler.CompilationError;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.classloader.ClassLoaderFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.war.WarFileSystem;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.request.spi.portlet.PortletActionBridge;
import juzu.impl.request.spi.portlet.PortletBridgeContext;
import juzu.impl.request.spi.portlet.PortletRenderBridge;
import juzu.impl.request.spi.portlet.PortletResourceBridge;
import juzu.impl.utils.DevClassLoader;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Tools;
import juzu.impl.utils.TrimmingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JuzuPortlet
implements Portlet,
ResourceServingPortlet {
    public static final PORTLET_MODE PORTLET_MODE = new PORTLET_MODE();
    public static final WINDOW_STATE WINDOW_STATE = new WINDOW_STATE();
    private PortletConfig config;
    private ApplicationRuntime<?, String, String> runtime;
    private boolean prod;
    private String srcPath;
    private String appName;
    private InjectImplementation injectImpl;
    private ReadFileSystem<String> libs;
    private ReadFileSystem<String> resources;
    private Logger log;
    private PortletBridgeContext bridge;

    public void init(final PortletConfig config) throws PortletException {
        InjectImplementation injectImpl;
        this.config = config;
        this.log = new Logger(){

            public void log(CharSequence msg) {
                System.out.println("[" + config.getPortletName() + "] " + msg);
            }

            public void log(CharSequence msg, Throwable t) {
                System.err.println("[" + config.getPortletName() + "] " + msg);
                t.printStackTrace();
            }
        };
        String runMode = config.getInitParameter("juzu.run_mode");
        runMode = runMode == null ? "prod" : runMode.trim().toLowerCase();
        String inject = config.getInitParameter("juzu.inject");
        if (inject == null) {
            injectImpl = InjectImplementation.CDI_WELD;
        } else if ("weld".equals(inject = inject.trim().toLowerCase())) {
            injectImpl = InjectImplementation.CDI_WELD;
        } else if ("spring".equals(inject)) {
            injectImpl = InjectImplementation.INJECT_SPRING;
        } else {
            throw new PortletException("unrecognized inject vendor " + inject);
        }
        this.log.log("Using injection " + injectImpl.name());
        this.appName = this.getApplicationName(config);
        this.prod = !"dev".equals(runMode);
        this.srcPath = config.getInitParameter("juzu.src_path");
        this.injectImpl = injectImpl;
        this.libs = WarFileSystem.create(config.getPortletContext(), "/WEB-INF/lib/");
        this.resources = WarFileSystem.create(config.getPortletContext(), "/WEB-INF/");
        Collection<CompilationError> errors = this.boot();
        if (errors != null && errors.size() > 0) {
            this.log.log("Error when compiling application " + errors);
        }
    }

    protected String getApplicationName(PortletConfig config) {
        return config.getInitParameter("juzu.app_name");
    }

    private Collection<CompilationError> boot() throws PortletException {
        if (this.runtime == null) {
            if (this.prod) {
                this.runtime = new ApplicationRuntime.Static(this.log);
                ((ApplicationRuntime.Static)this.runtime).setClasses(WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/classes/"));
                ((ApplicationRuntime.Static)this.runtime).setClassLoader(Thread.currentThread().getContextClassLoader());
            } else {
                try {
                    ReadFileSystem fss;
                    PortletContext context = this.config.getPortletContext();
                    ClassLoaderFileSystem classPath = (ClassLoaderFileSystem)context.getAttribute("juzu.clfs");
                    if (classPath == null) {
                        DevClassLoader devCL = new DevClassLoader(Thread.currentThread().getContextClassLoader());
                        classPath = new ClassLoaderFileSystem(devCL);
                        context.setAttribute("juzu.clfs", (Object)classPath);
                    }
                    this.runtime = new ApplicationRuntime.Dynamic(this.log);
                    if (this.srcPath != null) {
                        fss = new DiskFileSystem(new File(this.srcPath));
                        ((ApplicationRuntime.Dynamic)this.runtime).init(classPath, fss);
                    } else {
                        fss = WarFileSystem.create(this.config.getPortletContext(), "/WEB-INF/src/");
                        ((ApplicationRuntime.Dynamic)this.runtime).init(classPath, fss);
                    }
                }
                catch (Exception e) {
                    throw e instanceof PortletException ? (PortletException)e : new PortletException((Throwable)e);
                }
            }
            AssetServer server = (AssetServer)this.config.getPortletContext().getAttribute("asset.server");
            if (server == null) {
                server = new AssetServer();
                this.config.getPortletContext().setAttribute("asset.server", (Object)server);
            }
            this.runtime.setLibs(this.libs);
            this.runtime.setResources(this.resources);
            this.runtime.setInjectImplementation(this.injectImpl);
            this.runtime.setName(this.appName);
            this.runtime.setAssetServer(server);
        }
        try {
            Collection<CompilationError> boot = this.runtime.boot();
            if (boot == null || boot.isEmpty()) {
                this.bridge = new PortletBridgeContext(this.runtime, this.runtime.getScriptManager(), this.log, this.prod);
            }
            return boot;
        }
        catch (Exception e) {
            throw new PortletException("Could not find an application to start", (Throwable)e);
        }
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        PortletActionBridge bridge = this.bridge.create(request, response);
        try {
            this.runtime.getContext().invoke(bridge);
        }
        catch (ApplicationException e) {
            throw new PortletException(e.getCause());
        }
        finally {
            bridge.close();
        }
    }

    private void purgeSession(PortletRequest req) {
        PortletSession session = req.getPortletSession();
        for (String key : new HashSet(session.getAttributeMap().keySet())) {
            session.removeAttribute(key);
        }
    }

    public void render(final RenderRequest request, final RenderResponse response) throws PortletException, IOException {
        Collection<CompilationError> errors = this.boot();
        if (errors == null || errors.isEmpty()) {
            if (errors != null) {
                this.purgeSession((PortletRequest)request);
            }
            try {
                TrimmingException.invoke(new TrimmingException.Callback(){

                    public void call() throws Throwable {
                        PortletRenderBridge bridge = JuzuPortlet.this.bridge.create(request, response, !JuzuPortlet.this.prod);
                        try {
                            JuzuPortlet.this.runtime.getContext().invoke(bridge);
                            bridge.commit();
                        }
                        catch (ApplicationException e) {
                            throw e.getCause();
                        }
                        finally {
                            bridge.close();
                        }
                    }
                });
            }
            catch (TrimmingException e) {
                if (this.prod) {
                    throw new PortletException(e.getSource());
                }
                this.renderThrowable(response.getWriter(), e);
            }
        } else {
            this.renderErrors(response.getWriter(), errors);
        }
    }

    public void serveResource(final ResourceRequest request, final ResourceResponse response) throws PortletException, IOException {
        block9: {
            boolean assetRequest = "assets".equals(request.getParameter("juzu.request"));
            if (assetRequest && !this.prod) {
                InputStream in;
                String contentType;
                String path = request.getResourceID();
                if (this.runtime.getScriptManager().isClassPath(path)) {
                    contentType = "text/javascript";
                    in = this.runtime.getClassLoader().getResourceAsStream(path.substring(1));
                } else if (this.runtime.getStylesheetManager().isClassPath(path)) {
                    contentType = "text/css";
                    in = this.runtime.getClassLoader().getResourceAsStream(path.substring(1));
                } else {
                    contentType = null;
                    in = null;
                }
                if (in != null) {
                    response.setContentType(contentType);
                    Tools.copy(in, response.getPortletOutputStream());
                }
            } else {
                try {
                    TrimmingException.invoke(new TrimmingException.Callback(){

                        public void call() throws Throwable {
                            PortletResourceBridge bridge = JuzuPortlet.this.bridge.create(request, response, !JuzuPortlet.this.prod);
                            try {
                                JuzuPortlet.this.runtime.getContext().invoke(bridge);
                                bridge.commit();
                            }
                            catch (ApplicationException e) {
                                throw e.getCause();
                            }
                            finally {
                                bridge.close();
                            }
                        }
                    });
                }
                catch (TrimmingException e) {
                    response.setProperty("portlet.http-status-code", "500");
                    this.logThrowable(e);
                    if (this.prod) break block9;
                    PrintWriter writer = response.getWriter();
                    writer.print("<html>\n");
                    writer.print("<head>\n");
                    writer.print("</head>\n");
                    writer.print("<body>\n");
                    this.renderThrowable(writer, e);
                    writer.print("</body>\n");
                }
            }
        }
    }

    private void sendJuzuCSS(PrintWriter writer) throws IOException {
        URL cssURL = JuzuPortlet.class.getResource("juzu.css");
        String css = Tools.read(cssURL);
        css = css.replace("\"", "\\\"");
        css = css.replace("'", "\\'");
        css = css.replace("\n", "\\n");
        writer.append("<script type='text/javascript'>\n");
        writer.append("var styleElement = document.createElement('style');\n");
        writer.append("var css = '");
        writer.append(css);
        writer.append("';\n");
        writer.append("styleElement.type = 'text/css';\n");
        writer.append("if (styleElement.styleSheet) {;\n");
        writer.append("styleElement.styleSheet.cssText = css;\n");
        writer.append("} else {\n");
        writer.append("styleElement.appendChild(document.createTextNode(css));\n");
        writer.append("}\n");
        writer.append("document.getElementsByTagName(\"head\")[0].appendChild(styleElement);\n");
        writer.append("</script>\n");
    }

    private void logThrowable(Throwable t) {
        this.log.log(t.getMessage(), t);
    }

    private void logErrors(Collection<CompilationError> errors) {
        StringBuilder sb = new StringBuilder("Compilation errors:\n");
        for (CompilationError error : errors) {
            if (error.getSourceFile() != null) {
                sb.append(error.getSourceFile().getAbsolutePath());
            } else {
                sb.append(error.getSource());
            }
            sb.append(':').append(error.getLocation().getLine()).append(':').append(error.getMessage()).append('\n');
        }
        this.log.log(sb.toString());
    }

    private void renderThrowable(PrintWriter writer, Throwable t) throws PortletException, IOException {
        StackTraceElement[] trace;
        int size = 0;
        for (StackTraceElement element : trace = t.getStackTrace()) {
            if (element.getClassName().equals(JuzuPortlet.class.getName())) break;
            ++size;
        }
        StackTraceElement[] ourTrace = new StackTraceElement[size];
        System.arraycopy(trace, 0, ourTrace, 0, ourTrace.length);
        t.setStackTrace(ourTrace);
        this.sendJuzuCSS(writer);
        final AtomicBoolean open = new AtomicBoolean(false);
        PrintWriter formatter = new PrintWriter(writer){

            public void println(Object x) {
                if (open.get()) {
                    super.append("</ul></pre>");
                }
                super.append("<div class=\"juzu-message\">");
                super.append(String.valueOf(x));
                super.append("</div>");
                open.set(false);
            }

            public void println(String x) {
                if (!open.get()) {
                    super.append("<pre><ul>");
                    open.set(true);
                }
                super.append("<li><span>");
                super.append(x);
                super.append("</span></li>");
            }

            public void println() {
            }
        };
        writer.append("<div class=\"juzu\">");
        writer.append("<div class=\"juzu-box\">");
        t.printStackTrace(formatter);
        if (open.get()) {
            writer.append("</ul></pre>");
        }
        writer.append("</div>");
        writer.append("</div>");
    }

    private void renderErrors(PrintWriter writer, Collection<CompilationError> errors) throws PortletException, IOException {
        this.sendJuzuCSS(writer);
        writer.append("<div class=\"juzu\">");
        for (CompilationError error : errors) {
            writer.append("<div class=\"juzu-box\">");
            writer.append("<div class=\"juzu-message\">").append(error.getMessage()).append("</div>");
            File source = error.getSourceFile();
            if (source != null) {
                int line = error.getLocation().getLine();
                int from = line - 2;
                int to = line + 3;
                BufferedReader reader = new BufferedReader(new FileReader(source));
                int count = 1;
                writer.append("<pre><ol start=\"").append(String.valueOf(from)).append("\">");
                String s = reader.readLine();
                while (s != null) {
                    if (count >= from && count < to) {
                        if (count == line) {
                            writer.append("<li><span class=\"error\">").append(s).append("</span></li>");
                        } else {
                            writer.append("<li><span>").append(s).append("</span></li>");
                        }
                    }
                    ++count;
                    s = reader.readLine();
                }
                writer.append("</ol></pre>");
            }
            writer.append("</div>");
        }
        writer.append("</div>");
    }

    public void destroy() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class WINDOW_STATE
    extends PropertyType<WindowState> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PORTLET_MODE
    extends PropertyType<PortletMode> {
    }
}

