/*
 * Decompiled with CFR 0.152.
 */
package juzu.request;

import java.io.IOException;
import juzu.Response;
import juzu.URLBuilder;
import juzu.impl.application.ApplicationContext;
import juzu.impl.application.ApplicationDescriptor;
import juzu.impl.controller.descriptor.ControllerMethod;
import juzu.impl.request.Request;
import juzu.impl.request.spi.MimeBridge;
import juzu.io.AppendableStream;
import juzu.request.RequestContext;

public abstract class MimeContext
extends RequestContext {
    private final ApplicationContext application;

    protected MimeContext(Request request, ApplicationContext application, ControllerMethod method) {
        super(request, application, method);
        this.application = application;
    }

    protected abstract MimeBridge getBridge();

    public URLBuilder createURLBuilder(ControllerMethod method) {
        URLBuilder builder = new URLBuilder(this.getBridge(), method);
        ApplicationDescriptor desc = this.application.getDescriptor();
        builder.escapeXML(desc.getController().getEscapeXML());
        return builder;
    }

    public URLBuilder createURLBuilder(ControllerMethod method, Object arg) {
        URLBuilder builder = this.createURLBuilder(method);
        method.setArgs(new Object[]{arg}, builder.getParameters());
        return builder;
    }

    public URLBuilder createURLBuilder(ControllerMethod method, Object[] args) {
        URLBuilder builder = this.createURLBuilder(method);
        method.setArgs(args, builder.getParameters());
        return builder;
    }

    public void setResponse(Response.Content response) throws IOException, IllegalStateException {
        StringBuilder buffer = new StringBuilder();
        AppendableStream printer = new AppendableStream(buffer);
        response.send(printer);
        response = response instanceof Response.Render ? Response.render(((Response.Render)response).getTitle(), buffer.toString()) : Response.content((int)response.getStatus(), buffer.toString());
        this.request.setResponse(response);
    }
}

