/*
 * Decompiled with CFR 0.152.
 */
package juzu.template;

import java.io.IOException;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import juzu.PropertyMap;
import juzu.Response;
import juzu.impl.application.ApplicationException;
import juzu.impl.template.spi.TemplateStub;
import juzu.io.AppendableStream;
import juzu.io.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateRenderContext {
    private final Map<String, ?> attributes;
    private final Locale locale;
    private PropertyMap properties;
    protected Stream.Char printer;
    private final TemplateStub stub;

    public TemplateRenderContext(TemplateStub stub) {
        this(stub, Collections.emptyMap());
    }

    public TemplateRenderContext(TemplateStub stub, Map<String, ?> attributes) {
        this(stub, null, attributes, null);
    }

    public TemplateRenderContext(TemplateStub stub, Locale locale) {
        this(stub, null, Collections.emptyMap(), locale);
    }

    public TemplateRenderContext(TemplateStub stub, PropertyMap properties, Map<String, ?> attributes, Locale locale) {
        this.locale = locale;
        this.attributes = attributes;
        this.stub = stub;
        this.properties = properties;
    }

    public Map<String, ?> getAttributes() {
        return this.attributes;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Stream.Char getPrinter() {
        return this.printer;
    }

    public void setTitle(String title) {
        if (this.properties != null) {
            this.properties.setValue(Response.Render.TITLE, title);
        }
    }

    public TemplateStub resolveTemplate(String path) {
        return null;
    }

    public Object resolveBean(String expression) throws ApplicationException {
        return null;
    }

    public StringBuilder render() throws IOException {
        StringBuilder buffer = new StringBuilder();
        this.render(new AppendableStream(buffer));
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(Stream.Char printer) throws IOException {
        if (this.printer != null) {
            throw new IllegalStateException("Already rendering");
        }
        this.printer = printer;
        try {
            this.stub.render(this);
        }
        finally {
            this.printer = null;
        }
    }
}

