/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.classloader;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.portlet.Portlet;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.classloader.ClassLoaderFileSystem;
import juzu.impl.utils.Tools;
import juzu.test.AbstractTestCase;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import sun.net.www.protocol.foo.Handler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFileSystemTestCase
extends AbstractTestCase {
    private JavaArchive jar;

    public ClassLoaderFileSystemTestCase() {
        JavaArchive jar = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        jar.setManifest((Asset)new StringAsset(""));
        jar.addAsResource((Asset)new StringAsset("bar.txt_value"), "bar.txt");
        jar.addAsResource((Asset)new StringAsset("foo/bar.txt_value"), "foo/bar.txt");
        jar.addAsResource((Asset)new StringAsset("foo/bar/juu.txt_value"), "foo/bar/juu.txt");
        this.jar = jar;
    }

    @Test
    public void testJarFile() throws Exception {
        File f = File.createTempFile("test", ".jar");
        f.deleteOnExit();
        ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo(f, true);
        this.assertFS(f.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJarStream() throws Exception {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ((ZipExporter)this.jar.as(ZipExporter.class)).exportTo((OutputStream)baos);
            byte[] bytes = baos.toByteArray();
            Handler.bind("jarfile", bytes);
            URL url = new URL("foo:jarfile");
            String abc = url.toString();
            final URL manifestURL = new URL("jar:" + abc + "!/META-INF/MANIFEST.MF");
            final URL fooURL = new URL("jar:" + abc + "!/foo/");
            final URL barTxtURL = new URL("jar:" + abc + "!/foo/bar.txt");
            final URL barURL = new URL("jar:" + abc + "!/foo/bar/");
            final URL juuTxtURL = new URL("jar:" + abc + "!/foo/bar/juu.txt");
            ClassLoader cl = new ClassLoader(ClassLoader.getSystemClassLoader()){

                @Override
                protected URL findResource(String name) {
                    if ("META-INF/MANIFEST.MF".equals(name)) {
                        return manifestURL;
                    }
                    if ("foo/".equals(name)) {
                        return fooURL;
                    }
                    if ("foo/bar.txt".equals(name)) {
                        return barTxtURL;
                    }
                    if ("foo/bar/juu.txt".equals(name)) {
                        return barURL;
                    }
                    if ("foo/bar/juu.txt".equals(name)) {
                        return juuTxtURL;
                    }
                    return null;
                }

                @Override
                protected Enumeration<URL> findResources(String name) throws IOException {
                    Vector<URL> v = new Vector<URL>();
                    URL url = this.findResource(name);
                    if (url != null) {
                        v.add(url);
                    }
                    return v.elements();
                }
            };
            this.assertFS(cl);
        }
        finally {
            Handler.clear();
        }
    }

    @Test
    public void testFile() throws Exception {
        File f = File.createTempFile("test", "");
        ClassLoaderFileSystemTestCase.assertTrue((boolean)f.delete());
        ClassLoaderFileSystemTestCase.assertTrue((boolean)f.mkdirs());
        f.deleteOnExit();
        File dir = ((ExplodedExporter)this.jar.as(ExplodedExporter.class)).exportExploded(f);
        this.assertFS(dir.toURI().toURL());
    }

    @Test
    public void testPortletJar() throws Exception {
        URL url = Portlet.class.getProtectionDomain().getCodeSource().getLocation();
        URLClassLoader cl = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
        ClassLoaderFileSystem fs = new ClassLoaderFileSystem((ClassLoader)cl);
        Object s = fs.getPath(new String[]{"javax", "portlet"});
        ClassLoaderFileSystemTestCase.assertNotNull((Object)s);
    }

    private void assertFS(URL base) throws Exception {
        this.assertFS(new URLClassLoader(new URL[]{base}, ClassLoader.getSystemClassLoader()));
    }

    private void assertFS(ClassLoader classLoader) throws Exception {
        this.assertFS((SimpleFileSystem)new ClassLoaderFileSystem(classLoader));
    }

    private <P> void assertFS(SimpleFileSystem<P> fs) throws Exception {
        Object foo = fs.getPath(new String[]{"foo"});
        ClassLoaderFileSystemTestCase.assertEquals((String)"foo", (String)fs.getName(foo));
        ClassLoaderFileSystemTestCase.assertEquals((String)"foo", (String)((StringBuilder)fs.packageOf(foo, '.', (Appendable)new StringBuilder())).toString());
        ArrayList fooChildren = Tools.list((Iterator)fs.getChildren(foo));
        ClassLoaderFileSystemTestCase.assertEquals((int)1, (int)fooChildren.size());
        Object fooChild = fooChildren.get(0);
        ClassLoaderFileSystemTestCase.assertEquals((String)"foo", (String)((StringBuilder)fs.packageOf(fooChild, '/', (Appendable)new StringBuilder())).toString());
        ClassLoaderFileSystemTestCase.assertEquals((String)"bar.txt", (String)fs.getName(fooChild));
        Object fooBar = fs.getPath(new String[]{"foo", "bar.txt"});
        ClassLoaderFileSystemTestCase.assertEquals((String)"bar.txt", (String)fs.getName(fooBar));
        ClassLoaderFileSystemTestCase.assertEquals((String)"foo", (String)((StringBuilder)fs.packageOf(fooBar, '.', (Appendable)new StringBuilder())).toString());
        Object fooBarJuu = fs.getPath(new String[]{"foo", "bar", "juu.txt"});
        ClassLoaderFileSystemTestCase.assertEquals((String)"juu.txt", (String)fs.getName(fooBarJuu));
        ClassLoaderFileSystemTestCase.assertEquals((String)"foo.bar", (String)((StringBuilder)fs.packageOf(fooBarJuu, '.', (Appendable)new StringBuilder())).toString());
        ClassLoaderFileSystemTestCase.assertEquals(null, (Object)fs.getPath(new String[]{"juu"}));
    }
}

