/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template;

import java.io.Serializable;
import java.util.HashMap;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.template.metadata.TemplateDescriptor;
import juzu.impl.template.spi.EmitContext;
import juzu.impl.template.spi.ProcessContext;
import juzu.impl.template.spi.Template;
import juzu.impl.template.spi.juzu.DialectTemplateEmitter;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.ast.ParseException;
import juzu.impl.template.spi.juzu.compiler.EmitPhase;
import juzu.impl.template.spi.juzu.compiler.ProcessPhase;
import juzu.impl.template.spi.juzu.dialect.gtmpl.GroovyTemplateEmitter;
import juzu.impl.utils.Path;
import juzu.test.AbstractInjectTestCase;
import juzu.test.AbstractTestCase;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class TagTestCase
extends AbstractInjectTestCase {
    public TagTestCase(InjectImplementation di) {
        super(di);
    }

    public void _testSimple() throws Exception {
        MockApplication<?> app = this.application("template", "tag", "simple").init();
        app.init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String out = render.assertStringResult();
        TagTestCase.assertEquals((String)"<foo>bar</foo>", (String)out);
    }

    @Test
    public void testDecorate() throws Exception {
        MockApplication<?> app = this.application("template", "tag", "decorate").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String out = render.assertStringResult();
        TagTestCase.assertEquals((String)"<foo>bar</foo>", (String)out);
    }

    @Test
    public void testInclude() throws Exception {
        MockApplication<?> app = this.application("template", "tag", "include").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String out = render.assertStringResult();
        TagTestCase.assertEquals((String)"foo", (String)out);
    }

    @Test
    public void testTitle() throws Exception {
        MockApplication<?> app = this.application("template", "tag", "title").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        String url = render.assertStringResult();
        TagTestCase.assertEquals((String)"the_title", (String)render.getTitle());
        render = (MockRenderBridge)client.invoke(url);
        TagTestCase.assertEquals((String)"4", (String)render.getTitle());
    }

    @Test
    public void testParam() throws Exception {
        if (this.getDI() != InjectImplementation.INJECT_GUICE) {
            MockApplication<?> app = this.application("template", "tag", "param").init();
            MockClient client = app.client();
            MockRenderBridge render = client.render();
            String content = render.assertStringResult();
            TagTestCase.assertEquals((String)"foo_value", (String)content);
        }
    }

    @Test
    public void testRecompileTemplate() throws Exception {
        MockApplication<?> app = this.application("template", "tag", "decorate").init();
        TemplateDescriptor desc = app.getContext().getDescriptor().getTemplates().getTemplate("foo.gtmpl");
        TagTestCase.assertNotNull((Object)desc);
        Template foo = new Template(Path.parse((String)"index.gtmpl"), (Serializable)new ASTNode.Template(), Path.parse((String)(desc.getType().getName().replace('.', '/') + "/foo.gtmpl")), System.currentTimeMillis());
        HashMap<Path, Template> templates = new HashMap<Path, Template>();
        templates.put(Path.parse((String)"foo.gtmpl"), foo);
        ProcessPhase process = new ProcessPhase(new ProcessContext(templates){

            public <A extends Serializable> Template<A> resolveTemplate(Path originPath, Path path) {
                if (path.equals((Object)Path.parse((String)"index.gtmpl"))) {
                    try {
                        return new Template(Path.parse((String)"index.gtmpl"), (Serializable)ASTNode.Template.parse((CharSequence)"#{decorate path=foo.gtmpl/}juu"), Path.parse((String)"template/tag/decorate/templates/index.gtmpl"), System.currentTimeMillis());
                    }
                    catch (ParseException e) {
                        throw AbstractTestCase.failure(e);
                    }
                }
                return null;
            }
        });
        Template template = process.resolveTemplate(Path.parse((String)"index.gtmpl"));
        TagTestCase.assertNotNull((Object)template);
        EmitPhase emit = new EmitPhase(new EmitContext());
        emit.emit((DialectTemplateEmitter)new GroovyTemplateEmitter(), (ASTNode)template.getModel());
    }
}

