/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.WeakHashMap;
import javax.annotation.processing.Processor;
import javax.inject.Provider;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.Compiler;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.classloader.ClassLoaderFileSystem;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.metamodel.MetaModelProcessor;
import juzu.impl.utils.Tools;
import juzu.processor.MainProcessor;
import juzu.test.AbstractTestCase;
import juzu.test.CompileStrategy;
import juzu.test.JavaFile;
import juzu.test.protocol.mock.MockApplication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerAssert<I, O> {
    public static final Provider<MetaModelProcessor> META_MODEL_PROCESSOR_FACTORY = new Provider<MetaModelProcessor>(){

        public MetaModelProcessor get() {
            return new MainProcessor();
        }
    };
    private static WeakHashMap<ClassLoader, ClassLoaderFileSystem> classPathCache = new WeakHashMap();
    private ClassLoader baseClassLoader;
    private ClassLoader classLoader;
    private CompileStrategy<I, O> strategy;

    public CompilerAssert(boolean incremental, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
        ClassLoader baseClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderFileSystem classPath = classPathCache.get(baseClassLoader);
        if (classPath == null) {
            try {
                classPath = new ClassLoaderFileSystem(baseClassLoader);
                classPathCache.put(baseClassLoader, classPath);
            }
            catch (IOException e) {
                throw AbstractTestCase.failure(e);
            }
        }
        this.strategy = incremental ? new CompileStrategy.Incremental<I, O>((SimpleFileSystem<?>)classPath, sourcePath, sourceOutput, classOutput, (Provider<Processor>)META_MODEL_PROCESSOR_FACTORY) : new CompileStrategy.Batch<I, O>((SimpleFileSystem<?>)classPath, sourcePath, sourceOutput, classOutput, (Provider<Processor>)META_MODEL_PROCESSOR_FACTORY);
        this.baseClassLoader = baseClassLoader;
    }

    public CompilerAssert(ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> sourceOutput, ReadWriteFileSystem<O> classOutput) {
        this(false, sourcePath, sourceOutput, classOutput);
    }

    public CompilerAssert(ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> output) {
        this(false, sourcePath, output, output);
    }

    public CompilerAssert(boolean incremental, ReadWriteFileSystem<I> sourcePath, ReadWriteFileSystem<O> output) {
        this(incremental, sourcePath, output, output);
    }

    public CompilerAssert<I, O> with(Provider<? extends Processor> processorFactory) {
        this.strategy.processorFactory = processorFactory;
        return this;
    }

    public CompilerAssert<I, O> addClassPath(ReadFileSystem<?> classPath) {
        this.strategy.addClassPath(classPath);
        return this;
    }

    public ReadFileSystem<I> getSourcePath() {
        return this.strategy.sourcePath;
    }

    public ReadWriteFileSystem<O> getClassOutput() {
        return this.strategy.classOutput;
    }

    public ReadWriteFileSystem<O> getSourceOutput() {
        return this.strategy.sourceOutput;
    }

    public CompilerAssert<I, O> formalErrorReporting(boolean formalErrorReporting) {
        if (formalErrorReporting) {
            this.strategy.config.withProcessorOption("juzu.error_reporting", "formal");
        } else {
            this.strategy.config.withProcessorOption("juzu.error_reporting", null);
        }
        return this;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<CompilationError> failCompile() {
        try {
            List<CompilationError> errors = this.strategy.compile();
            AbstractTestCase.assertTrue((String)"Was expecting compilation to fail", (errors.size() > 0 ? 1 : 0) != 0);
            return errors;
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public MockApplication<?> application(InjectImplementation injectImplementation) {
        try {
            return new MockApplication<O>(this.getClassOutput(), this.classLoader, injectImplementation.bootstrap());
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public Compiler assertCompile() {
        try {
            List<CompilationError> errors = this.strategy.compile();
            AbstractTestCase.assertEquals((String)("Compilation failed : " + errors), Collections.emptyList(), errors);
            this.classLoader = new URLClassLoader(new URL[]{this.strategy.classOutput.getURL()}, this.baseClassLoader);
            return this.strategy.compiler;
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public Class<?> assertClass(String className) {
        try {
            return this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public void assertRemove(String ... names) {
        try {
            Object path = this.strategy.sourcePath.getPath(names);
            if (path == null) {
                throw AbstractTestCase.failure("Cannot remove path " + Tools.join((char)'/', (String[])names));
            }
            this.strategy.sourcePath.removePath(path);
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }

    public JavaFile<I> assertJavaFile(String ... names) {
        Object path;
        try {
            path = this.strategy.sourcePath.getPath(names);
        }
        catch (IOException e) {
            throw AbstractTestCase.failure(e);
        }
        if (path == null) {
            throw AbstractTestCase.failure("Was not expecting " + Arrays.asList(names) + " to be null file");
        }
        return new JavaFile<Object>(this.strategy.sourcePath, path);
    }
}

