/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import java.io.InputStream;
import java.util.List;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.utils.Content;
import juzu.test.AbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFile<I> {
    final ReadWriteFileSystem<I> sourcePath;
    final I path;
    private CompilationUnit cu;

    public JavaFile(ReadWriteFileSystem<I> sourcePath, I path) {
        this.sourcePath = sourcePath;
        this.path = path;
        this.cu = null;
    }

    public CompilationUnit assertCompilationUnit() {
        if (this.cu == null) {
            try {
                Content content = this.sourcePath.getContent(this.path);
                InputStream in = content.getInputStream();
                this.cu = JavaParser.parse((InputStream)in);
            }
            catch (Exception e) {
                throw AbstractTestCase.failure(e);
            }
        }
        return this.cu;
    }

    public ClassOrInterfaceDeclaration assertDeclaration() {
        List decls = this.assertCompilationUnit().getTypes();
        AbstractTestCase.assertEquals((int)1, (int)decls.size());
        TypeDeclaration decl = (TypeDeclaration)decls.get(0);
        return AbstractTestCase.assertInstanceOf(ClassOrInterfaceDeclaration.class, decl);
    }

    public void assertSave() {
        try {
            String s = this.cu.toString();
            this.sourcePath.setContent(this.path, new Content(0L, (CharSequence)s));
        }
        catch (Exception e) {
            throw AbstractTestCase.failure(e);
        }
    }
}

