/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs;

import java.io.IOException;
import java.util.Collections;
import juzu.impl.fs.Change;
import juzu.impl.fs.FileSystemScanner;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ram.RAMDir;
import juzu.impl.fs.spi.ram.RAMFile;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class ScannerTestCase
extends AbstractTestCase {
    @Test
    public void testFoo() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        RAMDir foo = fs.addDir((RAMPath)fs.getRoot(), "foo");
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        RAMFile bar = fs.addFile((RAMPath)foo, "bar.txt");
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("foo/bar.txt", Change.ADD), (Object)scanner.scan());
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        bar.update("value");
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("foo/bar.txt", Change.UPDATE), (Object)scanner.scan());
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        bar.del();
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.singletonMap("foo/bar.txt", Change.REMOVE), (Object)scanner.scan());
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }

    @Test
    public void testIgnoreHiddenFile() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        fs.addFile((RAMPath)fs.getRoot(), ".foo");
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }

    @Test
    public void testIgnoreHiddenDir() throws IOException {
        RAMFileSystem fs = new RAMFileSystem();
        FileSystemScanner scanner = FileSystemScanner.createTimestamped((ReadFileSystem)fs);
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
        fs.addFile((RAMPath)fs.addDir((RAMPath)fs.getRoot(), ".foo"), "bar.txt");
        ScannerTestCase.waitForOneMillis();
        ScannerTestCase.assertEquals(Collections.emptyMap(), (Object)scanner.scan());
    }
}

