/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi;

import java.io.File;
import juzu.Scope;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.inject.BeanFilter;
import juzu.impl.inject.ScopeController;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopingContext;
import juzu.impl.inject.spi.InjectBuilder;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.inject.spi.InjectManager;
import juzu.impl.inject.spi.ScopingContextImpl;
import juzu.impl.utils.Tools;
import juzu.test.AbstractInjectTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInjectManagerTestCase<B, I>
extends AbstractInjectTestCase {
    protected InjectBuilder bootstrap;
    protected InjectManager<B, I> mgr;
    protected ReadFileSystem<?> fs;
    protected ScopingContextImpl scopingContext;

    public AbstractInjectManagerTestCase(InjectImplementation di) {
        super(di);
    }

    protected final void init() throws Exception {
        this.init(Tools.split((CharSequence)((Object)((Object)this)).getClass().getPackage().getName(), (char)'.'));
    }

    protected final void init(String ... pkg) throws Exception {
        File root = new File(AbstractInjectManagerTestCase.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        AbstractInjectManagerTestCase.assertTrue((boolean)root.exists());
        AbstractInjectManagerTestCase.assertTrue((boolean)root.isDirectory());
        this.init((ReadFileSystem<?>)new DiskFileSystem(root, pkg), Thread.currentThread().getContextClassLoader());
    }

    protected final void init(ReadFileSystem<?> fs, ClassLoader classLoader) throws Exception {
        InjectBuilder bootstrap = this.getManager();
        bootstrap.addFileSystem(fs);
        bootstrap.setClassLoader(classLoader);
        bootstrap.setFilter(BeanFilter.DEFAULT);
        this.bootstrap = bootstrap;
        this.fs = fs;
    }

    protected final void boot(Scope ... scopes) throws Exception {
        for (Scope scope : scopes) {
            this.bootstrap.addScope(scope);
        }
        this.mgr = this.bootstrap.create();
    }

    protected final <T> T getBean(Class<T> beanType) throws Exception {
        Object bean = this.mgr.resolveBean(beanType);
        AbstractInjectManagerTestCase.assertNotNull((String)("Could not resolve bean of type " + beanType), (Object)bean);
        Object beanInstance = this.mgr.create(bean);
        AbstractInjectManagerTestCase.assertNotNull((String)("Could not create bean instance of type " + beanType + " from bean " + bean), (Object)beanInstance);
        Object o = this.mgr.get(bean, beanInstance);
        AbstractInjectManagerTestCase.assertNotNull((String)("Could not obtain bean object from bean instance " + beanInstance + " of type " + beanType), (Object)o);
        return beanType.cast(o);
    }

    protected final Object getBean(String beanName) throws Exception {
        Object bean = this.mgr.resolveBean(beanName);
        AbstractInjectManagerTestCase.assertNotNull((String)("Could not find bean " + beanName), (Object)bean);
        Object beanInstance = this.mgr.create(bean);
        AbstractInjectManagerTestCase.assertNotNull((Object)beanInstance);
        return this.mgr.get(bean, beanInstance);
    }

    protected final void beginScoping() throws Exception {
        if (this.scopingContext != null) {
            throw AbstractInjectManagerTestCase.failure("Already scoping");
        }
        this.scopingContext = new ScopingContextImpl();
        ScopeController.begin((ScopingContext)this.scopingContext);
    }

    protected final void endScoping() throws Exception {
        if (this.scopingContext == null) {
            throw AbstractInjectManagerTestCase.failure("Not scoping");
        }
        ScopeController.end();
        for (Scoped scoped : this.scopingContext.getEntries().values()) {
            scoped.destroy();
        }
        this.scopingContext = null;
    }

    protected final InjectBuilder getManager() throws Exception {
        return this.getDI().bootstrap();
    }
}

