/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import juzu.impl.compiler.CompilationError;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.fs.spi.ram.RAMPath;
import juzu.impl.template.metamodel.TemplateMetaModel;
import juzu.impl.template.metamodel.TemplateMetaModelPlugin;
import juzu.impl.utils.Content;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ProcessorTestCase
extends AbstractTestCase {
    @Test
    public void testTemplatePathMatching() {
        this.assertNotMatch("a");
        this.assertMatch("a.b", "", "a", "b");
        this.assertNotMatch("/a.b");
        this.assertMatch("a/b.c", "a/", "b", "c");
        this.assertNotMatch("/a/b.c");
        this.assertNotMatch("a/b");
    }

    private void assertMatch(String test, String expectedFolder, String expectedRawName, String expectedExtension) {
        Matcher matcher = TemplateMetaModelPlugin.PATH_PATTERN.matcher(test);
        ProcessorTestCase.assertTrue((String)("Was expecting " + test + " to match"), (boolean)matcher.matches());
        ProcessorTestCase.assertEquals((String)expectedFolder, (String)matcher.group(1));
        ProcessorTestCase.assertEquals((String)expectedRawName, (String)matcher.group(2));
        ProcessorTestCase.assertEquals((String)expectedExtension, (String)matcher.group(3));
    }

    private void assertNotMatch(String test) {
        Matcher matcher = TemplateMetaModelPlugin.PATH_PATTERN.matcher(test);
        ProcessorTestCase.assertFalse((String)("Was not expecting " + test + " to match"), (boolean)matcher.matches());
    }

    public void _testSimpleIncremental() throws Exception {
        DiskFileSystem fs = ProcessorTestCase.diskFS("processor", "simple");
        RAMFileSystem sourcePath = new RAMFileSystem();
        fs.copy((ReadWriteFileSystem)sourcePath);
        ((RAMPath)sourcePath.getPath(new String[]{"processor", "simple", "templates", "index.gtmpl"})).del();
        ((RAMPath)sourcePath.getPath(new String[]{"processor", "simple", "package-info.java"})).del();
        RAMFileSystem sourceOutput = new RAMFileSystem();
        RAMFileSystem classOutput = new RAMFileSystem();
        CompilerAssert helper = new CompilerAssert(sourcePath, sourceOutput, classOutput);
        helper.assertCompile();
        ProcessorTestCase.assertEquals((int)2, (int)classOutput.size(1));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"juzu", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A.class"}));
        fs.copy((ReadWriteFileSystem)sourcePath);
        ((RAMPath)sourcePath.getPath(new String[]{"processor", "simple", "templates", "index.gtmpl"})).del();
        helper = new CompilerAssert(sourcePath, sourceOutput, classOutput);
        List<CompilationError> errors = helper.failCompile();
        ProcessorTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        ProcessorTestCase.assertEquals((Object)TemplateMetaModel.TEMPLATE_NOT_RESOLVED.toString(), (Object)error.getCode());
        ProcessorTestCase.assertEquals((int)2, (int)classOutput.size(1));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"juzu", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A.class"}));
        fs.copy((ReadWriteFileSystem)sourcePath);
        ((RAMPath)sourcePath.getPath(new String[]{"processor", "simple", "A.java"})).del();
        ((RAMPath)classOutput.getPath(new String[]{"processor", "simple", "A.class"})).del();
        helper = new CompilerAssert(sourcePath, sourceOutput, classOutput);
    }

    public void _testModifyTemplate() throws Exception {
        DiskFileSystem fs = ProcessorTestCase.diskFS("processor", "simple");
        RAMFileSystem sourcePath = new RAMFileSystem();
        fs.copy((ReadWriteFileSystem)sourcePath);
        RAMFileSystem sourceOutput = new RAMFileSystem();
        RAMFileSystem classOutput = new RAMFileSystem();
        CompilerAssert compiler = new CompilerAssert(sourcePath, sourceOutput, classOutput);
        compiler.assertCompile();
        ProcessorTestCase.assertEquals((int)9, (int)classOutput.size(1));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"juzu", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "templates", "index.groovy"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "package-info.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "SimpleApplication.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A_.class"}));
        Content c1 = ((RAMPath)classOutput.getPath(new String[]{"processor", "simple", "templates", "index.groovy"})).getContent();
        ((RAMPath)sourcePath.getPath(new String[]{"processor", "simple", "templates", "index.gtmpl"})).update("foo");
        ((RAMPath)classOutput.getPath(new String[]{"processor", "simple", "A.class"})).del();
        ((RAMPath)classOutput.getPath(new String[]{"processor", "simple", "A_.class"})).del();
        compiler = new CompilerAssert(sourcePath, sourceOutput, classOutput);
        compiler.assertCompile();
        ProcessorTestCase.assertEquals((int)9, (int)classOutput.size(1));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"juzu", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "templates", "index.groovy"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "config.properties"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "package-info.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "SimpleApplication.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A.class"}));
        ProcessorTestCase.assertNotNull((Object)classOutput.getPath(new String[]{"processor", "simple", "A_.class"}));
        Content c2 = ((RAMPath)classOutput.getPath(new String[]{"processor", "simple", "templates", "index.groovy"})).getContent();
        ProcessorTestCase.assertFalse((String)"Was not expecting templates to be identical", (boolean)((Object)c1.getCharSequence()).toString().equals(((Object)c2.getCharSequence()).toString()));
    }

    @Test
    public void testRemoveTemplate() throws Exception {
        CompilerAssert<File, File> helper = this.compiler("model", "processor", "simple");
        helper.assertCompile();
        ProcessorTestCase.assertDelete((File)helper.getSourcePath().getPath(new String[]{"model", "processor", "simple", "templates", "index.gtmpl"}));
        helper.addClassPath((ReadFileSystem<?>)helper.getClassOutput()).failCompile();
    }
}

