/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.io.File;
import java.util.List;
import juzu.impl.application.ApplicationException;
import juzu.impl.compiler.CompilationError;
import juzu.impl.inject.spi.InjectImplementation;
import juzu.impl.plugin.binding.BindingMetaModelPlugin;
import juzu.test.AbstractInjectTestCase;
import juzu.test.CompilerAssert;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class BindingProviderFactoryTestCase
extends AbstractInjectTestCase {
    public BindingProviderFactoryTestCase(InjectImplementation di) {
        super(di);
    }

    @Test
    public void testNoPublicCtor() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin", "binding", "provider", "factory", "nopublicctor");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NO_PUBLIC_CTOR, (Object)error.getCode());
        BindingProviderFactoryTestCase.assertEquals((String)"/plugin/binding/provider/factory/nopublicctor/package-info.java", (String)error.getSource());
    }

    @Test
    public void testNoZeroCtor() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin", "binding", "provider", "factory", "nozeroargctor");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NO_ZERO_ARG_CTOR, (Object)error.getCode());
        BindingProviderFactoryTestCase.assertEquals((String)"/plugin/binding/provider/factory/nozeroargctor/package-info.java", (String)error.getSource());
    }

    @Test
    public void testAbstractClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin", "binding", "provider", "factory", "abstractclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_NOT_ABSTRACT, (Object)error.getCode());
        BindingProviderFactoryTestCase.assertEquals((String)"/plugin/binding/provider/factory/abstractclass/package-info.java", (String)error.getSource());
    }

    @Test
    public void testNotPublicClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin", "binding", "provider", "factory", "notpublicclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.PROVIDER_FACTORY_NOT_PUBLIC, (Object)error.getCode());
        BindingProviderFactoryTestCase.assertEquals((String)"/plugin/binding/provider/factory/notpublicclass/package-info.java", (String)error.getSource());
    }

    @Test
    public void testNotClass() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin", "binding", "provider", "factory", "notclass");
        compiler.formalErrorReporting(true);
        List<CompilationError> errors = compiler.failCompile();
        BindingProviderFactoryTestCase.assertEquals((int)1, (int)errors.size());
        CompilationError error = errors.get(0);
        BindingProviderFactoryTestCase.assertEquals((Object)BindingMetaModelPlugin.IMPLEMENTATION_INVALID_TYPE, (Object)error.getCode());
        BindingProviderFactoryTestCase.assertEquals((String)"/plugin/binding/provider/factory/notclass/package-info.java", (String)error.getSource());
    }

    @Test
    public void testCreate() throws Exception {
        MockApplication<?> app = this.application("plugin", "binding", "provider", "factory", "create").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render();
        BindingProviderFactoryTestCase.assertEquals((String)"pass", (String)render.assertStringResult());
    }

    @Test
    public void testGetProviderThrowable() throws Exception {
        MockApplication<?> app = this.application("plugin", "binding", "provider", "factory", "throwable");
        try {
            app.init();
            BindingProviderFactoryTestCase.fail();
        }
        catch (ApplicationException e) {
            BindingProviderFactoryTestCase.assertInstanceOf(SecurityException.class, e.getCause());
        }
    }
}

