/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import juzu.impl.compiler.CompilationException;
import juzu.impl.compiler.CompilationMessage;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.utils.Logger;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String lineSep = System.getProperty("line.separator");
    private static final ThreadLocal<StringBuilder> currentLog = new ThreadLocal();
    private static final ThreadLocal<DateFormat> format = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("h:mm:ss:SSS");
        }
    };
    private static final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private static final Logger logger = BaseProcessor.getLogger(BaseProcessor.class);
    private boolean formalErrorReporting = false;
    private ProcessingContext context;

    public static Logger getLogger(Class<?> type) {
        String key = type.getName();
        final String name = type.getSimpleName();
        Logger logger = loggers.get(key);
        if (logger == null) {
            logger = new Logger(){

                public void log(CharSequence msg) {
                    BaseProcessor.log(name, msg);
                }

                public void log(CharSequence msg, Throwable t) {
                    BaseProcessor.log(name, msg, t);
                }
            };
            loggers.put(key, logger);
        }
        return logger;
    }

    private static void log(String name, CharSequence msg) {
        String s = format.get().format(new Date());
        StringBuilder sb = currentLog.get();
        if (sb != null) {
            sb.append(s).append(" ").append("[").append(name).append("] ").append(msg).append(lineSep);
        }
    }

    private static void log(String name, CharSequence msg, Throwable t) {
        StringWriter buffer = new StringWriter();
        t.printStackTrace(new PrintWriter(buffer));
        BaseProcessor.log(name, msg);
        StringBuilder sb = currentLog.get();
        if (sb != null) {
            sb.append(buffer);
        }
    }

    protected BaseProcessor() {
    }

    public final boolean getFormalErrorReporting() {
        return this.formalErrorReporting;
    }

    public final ProcessingContext getContext() {
        return this.context;
    }

    @Override
    public final Set<String> getSupportedOptions() {
        Set<String> options = super.getSupportedOptions();
        HashSet<String> our = new HashSet<String>(options);
        our.add("juzu.error_reporting");
        return our;
    }

    @Override
    public final void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        currentLog.set(new StringBuilder());
        this.formalErrorReporting = "formal".equalsIgnoreCase(processingEnv.getOptions().get("juzu.error_reporting"));
        this.context = new ProcessingContext(processingEnv);
        this.doInit(this.context);
    }

    @Override
    public final Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    protected void doInit(ProcessingContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        block36: {
            String s2;
            String t2;
            block37: {
                this.doProcess(annotations, roundEnv);
                Object var14_3 = null;
                if (!roundEnv.processingOver()) break block36;
                t2 = currentLog.get().toString();
                currentLog.set(null);
                if (t2.length() <= 0) break block36;
                s2 = null;
                InputStream in = null;
                try {
                    FileObject file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                    in = file.openInputStream();
                    s2 = Tools.read(in, "UTF-8");
                    Object var20_18 = null;
                }
                catch (Throwable throwable) {
                    Object var20_20 = null;
                    Tools.safeClose(in);
                    throw throwable;
                }
                Tools.safeClose(in);
                {
                    break block37;
                    catch (Exception ignore) {
                        Object var20_19 = null;
                        Tools.safeClose(in);
                    }
                }
            }
            OutputStream out = null;
            try {
                FileObject file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                out = file.openOutputStream();
                if (s2 != null) {
                    out.write(s2.getBytes("UTF-8"));
                }
                out.write(t2.getBytes("UTF-8"));
                Object var22_36 = null;
            }
            catch (Throwable throwable) {
                Object var22_38 = null;
                Tools.safeClose(out);
                throw throwable;
            }
            Tools.safeClose(out);
            {
                break block36;
                catch (Exception ignore) {
                    Object var22_37 = null;
                    Tools.safeClose(out);
                    break block36;
                }
            }
            {
                catch (Exception e) {
                    String s2;
                    String t2;
                    block38: {
                        if (e instanceof CompilationException) {
                            CompilationException ce = (CompilationException)e;
                            Element element = ce.getElement();
                            AnnotationMirror annotation = ce.getAnnotation();
                            StringBuilder msg = new StringBuilder();
                            for (CompilationMessage cm : ce) {
                                msg.setLength(0);
                                MessageCode code = cm.getCode();
                                Object[] args = cm.getArguments();
                                if (this.formalErrorReporting) {
                                    msg = msg.append("[").append(code.getKey()).append("](");
                                    for (int i = 0; i < args.length; ++i) {
                                        if (i > 0) {
                                            msg.append(',');
                                        }
                                        msg.append(String.valueOf(args[i]));
                                    }
                                    msg.append(")");
                                } else {
                                    new Formatter(msg).format(Locale.getDefault(), code.getMessage(), args).flush();
                                }
                                StringWriter writer = new StringWriter();
                                if (element == null) {
                                    writer.append("Compilation error: ");
                                } else if (annotation == null) {
                                    writer.append("Compilation error for element ").append(element.toString()).append(": ");
                                } else {
                                    writer.append("Compilation error for element ").append(element.toString()).append(" at annotation ").append(annotation.toString()).append(": ");
                                }
                                writer.append(msg).append("\n");
                                e.printStackTrace(new PrintWriter(writer));
                                logger.log(writer.getBuffer());
                                this.context.report(Diagnostic.Kind.ERROR, msg, element, annotation, null);
                            }
                        } else {
                            String msg = e.getMessage() == null ? "Exception : " + e.getClass().getName() : e.getMessage();
                            StringWriter writer = new StringWriter();
                            writer.append("Compilation error: ");
                            writer.append(msg).append("\n");
                            e.printStackTrace(new PrintWriter(writer));
                            logger.log(writer.getBuffer());
                            this.context.report(Diagnostic.Kind.ERROR, msg, null, null, null);
                        }
                        Object var14_4 = null;
                        if (!roundEnv.processingOver()) break block36;
                        t2 = currentLog.get().toString();
                        currentLog.set(null);
                        if (t2.length() <= 0) break block36;
                        s2 = null;
                        InputStream in = null;
                        try {
                            FileObject file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                            in = file.openInputStream();
                            s2 = Tools.read(in, "UTF-8");
                            Object var20_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var20_23 = null;
                            Tools.safeClose(in);
                            throw throwable;
                        }
                        Tools.safeClose(in);
                        {
                            break block38;
                            catch (Exception ignore) {
                                Object var20_22 = null;
                                Tools.safeClose(in);
                            }
                        }
                    }
                    out = null;
                    try {
                        FileObject file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                        out = file.openOutputStream();
                        if (s2 != null) {
                            out.write(s2.getBytes("UTF-8"));
                        }
                        out.write(t2.getBytes("UTF-8"));
                        Object var22_39 = null;
                    }
                    catch (Throwable throwable) {
                        Object var22_41 = null;
                        Tools.safeClose(out);
                        throw throwable;
                    }
                    Tools.safeClose(out);
                    {
                        break block36;
                        catch (Exception ignore) {
                            Object var22_40 = null;
                            Tools.safeClose(out);
                            break block36;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block40: {
                    Object var14_5 = null;
                    if (roundEnv.processingOver()) {
                        String t2 = currentLog.get().toString();
                        currentLog.set(null);
                        if (t2.length() > 0) {
                            String s2;
                            block39: {
                                s2 = null;
                                InputStream in = null;
                                try {
                                    FileObject file = this.context.getResource(StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log");
                                    in = file.openInputStream();
                                    s2 = Tools.read(in, "UTF-8");
                                    Object var20_24 = null;
                                }
                                catch (Throwable throwable2) {
                                    Object var20_26 = null;
                                    Tools.safeClose(in);
                                    throw throwable2;
                                }
                                Tools.safeClose(in);
                                {
                                    break block39;
                                    catch (Exception ignore) {
                                        Object var20_25 = null;
                                        Tools.safeClose(in);
                                    }
                                }
                            }
                            out = null;
                            try {
                                FileObject file = this.context.createResource((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "juzu", "processor.log", new Element[0]);
                                out = file.openOutputStream();
                                if (s2 != null) {
                                    out.write(s2.getBytes("UTF-8"));
                                }
                                out.write(t2.getBytes("UTF-8"));
                                Object var22_42 = null;
                            }
                            catch (Throwable throwable3) {
                                Object var22_44 = null;
                                Tools.safeClose(out);
                                throw throwable3;
                            }
                            Tools.safeClose(out);
                            {
                                break block40;
                                catch (Exception ignore) {
                                    Object var22_43 = null;
                                    Tools.safeClose(out);
                                }
                            }
                        }
                    }
                }
                throw throwable;
            }
        }
        return false;
    }

    protected abstract void doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2) throws CompilationException;
}

