/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.compiler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import juzu.impl.compiler.CompilationError;
import juzu.impl.compiler.CompilerConfig;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.VirtualFileManager;
import juzu.impl.compiler.file.FileKey;
import juzu.impl.compiler.file.JavaFileObjectImpl;
import juzu.impl.compiler.file.SimpleFileManager;
import juzu.impl.fs.Filter;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.ram.RAMFileSystem;
import juzu.impl.utils.Location;
import juzu.impl.utils.Spliterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler {
    static final Pattern PATTERN = Pattern.compile("\\[([^\\]]+)\\]\\(([^\\)]*)\\)");
    private JavaCompiler compiler;
    private Set<Processor> processors;
    private ReadFileSystem<?> sourcePath;
    private ReadWriteFileSystem<?> classOutput;
    private ReadWriteFileSystem<?> sourceOutput;
    private Collection<SimpleFileSystem<?>> classPaths;
    private CompilerConfig config;

    public static Builder builder() {
        return new Builder(null, null, null, new ArrayList());
    }

    public Compiler(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> output, CompilerConfig config) {
        this(sourcePath, output, output, config);
    }

    public Compiler(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput, CompilerConfig config) {
        this(sourcePath, Collections.emptyList(), sourceOutput, classOutput, config);
    }

    public Compiler(ReadFileSystem<?> sourcePath, SimpleFileSystem<?> classPath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput, CompilerConfig config) {
        this(sourcePath, Collections.singletonList(classPath), sourceOutput, classOutput, config);
    }

    public Compiler(ReadFileSystem<?> sourcePath, Collection<SimpleFileSystem<?>> classPaths, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput, CompilerConfig config) {
        this.sourcePath = sourcePath;
        this.classPaths = classPaths;
        this.sourceOutput = sourceOutput;
        this.classOutput = classOutput;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.processors = new HashSet<Processor>();
        this.config = config;
    }

    public void addAnnotationProcessor(Processor annotationProcessorType) {
        if (annotationProcessorType == null) {
            throw new NullPointerException("No null processor allowed");
        }
        this.processors.add(annotationProcessorType);
    }

    public List<CompilationError> compile(String ... compilationUnits) throws IOException {
        RAMFileSystem sourcePath1 = new RAMFileSystem();
        this.sourcePath.copy(new Filter(){

            public boolean acceptDir(Object dir, String name) throws IOException {
                return true;
            }

            public boolean acceptFile(Object file, String name) throws IOException {
                return !name.endsWith(".java");
            }
        }, sourcePath1);
        VirtualFileManager fileManager = new VirtualFileManager(this.compiler.getStandardFileManager(null, null, null), sourcePath1, this.classPaths, this.sourceOutput, this.classOutput);
        Collection<JavaFileObject> files = this.getFromSourcePath(this.sourcePath, compilationUnits);
        return this.compile(fileManager, files);
    }

    private <P> Collection<JavaFileObject> getFromSourcePath(ReadFileSystem<P> fs, String ... compilationUnits) throws IOException {
        SimpleFileManager<P> manager = new SimpleFileManager<P>(fs);
        ArrayList tmp = new ArrayList();
        ArrayList<JavaFileObject> javaFiles = new ArrayList<JavaFileObject>();
        for (String compilationUnit : compilationUnits) {
            tmp.clear();
            ArrayList<String> names = Spliterator.split(compilationUnit, '/', tmp);
            String name = (String)tmp.get(tmp.size() - 1);
            if (!name.endsWith(".java")) {
                throw new IllegalArgumentException("Illegal compilation unit: " + compilationUnit);
            }
            P file = manager.getFileSystem().getPath(names);
            if (file == null) {
                throw new IllegalArgumentException("Could not find compilation unit: " + compilationUnit);
            }
            StringBuilder sb = new StringBuilder();
            manager.getFileSystem().packageOf(file, '.', sb);
            FileKey key = FileKey.newJavaName(sb.toString(), name.substring(0, name.length()));
            javaFiles.add(manager.getReadable(key));
        }
        return javaFiles;
    }

    public List<CompilationError> compile() throws IOException {
        VirtualFileManager fileManager = new VirtualFileManager(this.compiler.getStandardFileManager(null, null, null), this.sourcePath, this.classPaths, this.sourceOutput, this.classOutput);
        return this.compile(fileManager, this.getFromSourcePath(fileManager.sourcePath));
    }

    private <P> Collection<JavaFileObject> getFromSourcePath(final SimpleFileManager<P> fileManager) throws IOException {
        final ArrayList<JavaFileObject> javaFiles = new ArrayList<JavaFileObject>();
        ((ReadFileSystem)fileManager.getFileSystem()).traverse(new Visitor.Default<P>(){

            @Override
            public void file(P file, String name) throws IOException {
                if (name.endsWith(".java")) {
                    StringBuilder sb = new StringBuilder();
                    fileManager.getFileSystem().packageOf(file, '.', sb);
                    FileKey key = FileKey.newJavaName(sb.toString(), name);
                    javaFiles.add(fileManager.getReadable(key));
                }
            }
        });
        return javaFiles;
    }

    private List<CompilationError> compile(VirtualFileManager fileManager, Collection<JavaFileObject> compilationUnits) throws IOException {
        if (compilationUnits.isEmpty()) {
            if (!this.config.getForce()) {
                return Collections.emptyList();
            }
            URI uri = URI.create("/Dumb.java");
            compilationUnits = Collections.singleton(new SimpleJavaFileObject(uri, JavaFileObject.Kind.SOURCE){

                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return "public class Dumb {}";
                }
            });
        }
        final ArrayList errors = new ArrayList();
        DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    int columnNumber = (int)diagnostic.getColumnNumber();
                    int lineNumber = (int)diagnostic.getLineNumber();
                    Location location = columnNumber > 0 && lineNumber > 0 ? new Location(columnNumber, lineNumber) : null;
                    String message = diagnostic.getMessage(null);
                    MessageCode code = null;
                    List<String> arguments = Collections.emptyList();
                    Matcher matcher = PATTERN.matcher(message);
                    if (matcher.find()) {
                        String codeKey = matcher.group(1);
                        code = MessageCode.decode(codeKey);
                        if (matcher.group(2).length() > 0) {
                            arguments = new ArrayList();
                            for (String argument : Spliterator.split(matcher.group(2), ',')) {
                                arguments.add(argument.trim());
                            }
                        }
                    }
                    JavaFileObject obj = diagnostic.getSource();
                    String source = null;
                    File resolvedFile = null;
                    if (obj != null) {
                        source = obj.toUri().getPath();
                        if (obj instanceof JavaFileObjectImpl) {
                            JavaFileObjectImpl foo = (JavaFileObjectImpl)obj;
                            try {
                                resolvedFile = foo.getFile();
                            }
                            catch (Exception ignore) {
                                // empty catch block
                            }
                        }
                    }
                    errors.add(new CompilationError(code, arguments, source, resolvedFile, location, message));
                }
            }
        };
        ArrayList<String> options = null;
        for (String optionName : this.config.getProcessorOptionNames()) {
            if (options == null) {
                options = new ArrayList<String>();
            }
            options.add("-A" + optionName + "=" + this.config.getProcessorOptionValue(optionName));
        }
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, (DiagnosticListener<? super JavaFileObject>)listener, options, null, compilationUnits);
        task.setProcessors(this.processors);
        boolean ok = task.call();
        fileManager.sourceOutput.clearCache();
        fileManager.classOutput.clearCache();
        fileManager.sourceOutput.clearCache();
        if (fileManager.classPath != null) {
            fileManager.classPath.clearCache();
        }
        this.processors.clear();
        return ok ? Collections.emptyList() : errors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private ReadFileSystem<?> sourcePath;
        private ReadWriteFileSystem<?> classOutput;
        private ReadWriteFileSystem<?> sourceOutput;
        private List<SimpleFileSystem<?>> classPaths;
        private CompilerConfig config;

        private Builder(ReadFileSystem<?> sourcePath, ReadWriteFileSystem<?> sourceOutput, ReadWriteFileSystem<?> classOutput, List<SimpleFileSystem<?>> classPaths) {
            this.sourcePath = sourcePath;
            this.sourceOutput = sourceOutput;
            this.classOutput = classOutput;
            this.classPaths = classPaths;
            this.config = new CompilerConfig();
        }

        public Builder classOutput(ReadWriteFileSystem<?> classOutput) {
            this.classOutput = classOutput;
            return this;
        }

        public Builder output(ReadWriteFileSystem<?> output) {
            this.sourceOutput = output;
            this.classOutput = this.sourceOutput;
            return this;
        }

        public Builder sourcePath(ReadFileSystem<?> sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public Builder sourceOutput(ReadWriteFileSystem<?> sourceOutput) {
            this.sourceOutput = sourceOutput;
            return this;
        }

        public Builder addClassPath(SimpleFileSystem<?> classPath) {
            this.classPaths.add(classPath);
            return this;
        }

        public Builder addClassPath(Iterable<SimpleFileSystem<?>> classPaths) {
            for (SimpleFileSystem<?> classPath : classPaths) {
                this.addClassPath(classPath);
            }
            return this;
        }

        public Builder config(CompilerConfig config) {
            this.config = config;
            return this;
        }

        public Compiler build() {
            return this.build(null);
        }

        public Compiler build(Processor processor) {
            if (this.sourcePath == null) {
                throw new IllegalStateException("No null source path");
            }
            if (this.classOutput == null) {
                throw new IllegalStateException("No null class output");
            }
            if (this.sourceOutput == null) {
                throw new IllegalStateException("No null source output");
            }
            Compiler compiler = new Compiler(this.sourcePath, this.classPaths, this.sourceOutput, this.classOutput, this.config);
            if (processor != null) {
                compiler.addAnnotationProcessor(processor);
            }
            return compiler;
        }
    }
}

