/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import juzu.impl.fs.spi.SimpleFileSystem;
import juzu.impl.fs.spi.classloader.URLCache;
import juzu.impl.utils.Content;
import juzu.impl.utils.Tools;
import juzu.impl.utils.Trie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFileSystem
extends SimpleFileSystem<Trie<String, URL>> {
    private final URLCache cache;
    private final ClassLoader classLoader;

    public ClassLoaderFileSystem(ClassLoader classLoader) throws IOException {
        URLCache cache = new URLCache();
        cache.add(classLoader);
        cache.add(Inject.class);
        this.cache = cache;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getDescription() {
        return "ClassLoader[]";
    }

    @Override
    public Trie<String, URL> getPath(Iterable<String> names) throws IOException {
        return this.cache.get(names);
    }

    @Override
    public String getName(Trie<String, URL> path) throws IOException {
        return path.getKey();
    }

    @Override
    public void packageOf(Trie<String, URL> path, Collection<String> to) throws IOException {
        Trie<String, URL> trie = this.cache.get(path.getPath());
        if (trie == null) {
            throw new IOException();
        }
        Iterator<String> iterator = path.getPath().iterator();
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (trie.value() != null && !iterator.hasNext()) continue;
            to.add(next);
        }
    }

    @Override
    public Iterator<Trie<String, URL>> getChildren(Trie<String, URL> dir) throws IOException {
        final Iterator<Trie<String, URL>> entries = dir.getEntries();
        return new Iterator<Trie<String, URL>>(){
            private Trie<String, URL> next;

            @Override
            public boolean hasNext() {
                while (this.next == null && entries.hasNext()) {
                    Trie next = (Trie)entries.next();
                    if (next.value() == null) continue;
                    this.next = next;
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Trie<String, URL> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Trie<String, URL> trie = this.next;
                    return trie;
                }
                finally {
                    this.next = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isDir(Trie<String, URL> path) throws IOException {
        return path.value() == null;
    }

    @Override
    public boolean isFile(Trie<String, URL> path) throws IOException {
        return !this.isDir(path);
    }

    @Override
    public Content getContent(Trie<String, URL> file) throws IOException {
        URL url = file.value();
        if (url == null) {
            throw new IOException("Cannot find file " + url);
        }
        URLConnection conn = url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Content(lastModified, bytes, Charset.defaultCharset());
    }

    @Override
    public File getFile(Trie<String, URL> path) throws IOException {
        throw new UnsupportedOperationException();
    }
}

