/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.jar;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.jar.JarPath;
import juzu.impl.utils.Content;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileSystem
extends ReadFileSystem<JarPath> {
    final JarFile jar;
    final URL jarURL;
    private final JarPath root;

    public JarFileSystem(JarFile f) throws IOException {
        this.jar = f;
        this.jarURL = new File(f.getName()).toURI().toURL();
        JarPath root = new JarPath(this);
        Enumeration<JarEntry> en = this.jar.entries();
        while (en.hasMoreElements()) {
            JarEntry entry = en.nextElement();
            root.append(entry);
        }
        this.root = root;
    }

    @Override
    public String getDescription() {
        return "jar[" + this.jarURL + "]";
    }

    @Override
    public boolean equals(JarPath left, JarPath right) {
        return left == right;
    }

    @Override
    public JarPath getRoot() throws IOException {
        return this.root;
    }

    @Override
    public JarPath getParent(JarPath path) throws IOException {
        return path.parent;
    }

    @Override
    public String getName(JarPath path) throws IOException {
        return path.name;
    }

    @Override
    public Iterator<JarPath> getChildren(JarPath dir) throws IOException {
        if (this.isFile(dir)) {
            throw new IllegalArgumentException("Not a directory");
        }
        return dir.getChildren();
    }

    @Override
    public JarPath getChild(JarPath dir, String name) throws IOException {
        if (this.isFile(dir)) {
            throw new IllegalArgumentException("Not a directory");
        }
        return dir.getChild(name);
    }

    @Override
    public boolean isDir(JarPath path) throws IOException {
        return path.dir;
    }

    @Override
    public boolean isFile(JarPath path) throws IOException {
        return !this.isDir(path);
    }

    @Override
    public Content getContent(JarPath file) throws IOException {
        return file.getContent();
    }

    @Override
    public long getLastModified(JarPath path) throws IOException {
        return 0L;
    }

    @Override
    public URL getURL(JarPath path) throws IOException {
        return path.getURL();
    }

    @Override
    public File getFile(JarPath path) throws IOException {
        return null;
    }
}

