/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject.spi.spring;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import juzu.impl.inject.spi.spring.SpringBuilder;
import org.springframework.beans.BeanMetadataAttribute;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractBean {
    final Class<?> type;
    final List<AutowireCandidateQualifier> qualifiers;

    AbstractBean(Class<?> type, Iterable<Annotation> qualifiers) {
        ArrayList<AutowireCandidateQualifier> list = null;
        if (qualifiers != null) {
            list = new ArrayList<AutowireCandidateQualifier>();
            for (Annotation annotation : qualifiers) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                AutowireCandidateQualifier md = new AutowireCandidateQualifier(annotationType.getName());
                for (Method method : annotationType.getMethods()) {
                    if (method.getParameterTypes().length != 0 || method.getDeclaringClass() == Object.class) continue;
                    try {
                        String attrName = method.getName();
                        Object attrValue = method.invoke((Object)annotation, new Object[0]);
                        md.addMetadataAttribute(new BeanMetadataAttribute(attrName, attrValue));
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException("handle me gracefully", e);
                    }
                }
                list.add(md);
            }
        }
        this.type = type;
        this.qualifiers = list;
    }

    abstract void configure(String var1, SpringBuilder var2, DefaultListableBeanFactory var3);
}

