/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.utils.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Key<O extends MetaModelObject>
implements Serializable {
    public static <O extends MetaModelObject> Key<O> of(Object value, Class<O> type) {
        return new Wrapper(value, type);
    }

    public static <O extends MetaModelObject> Key<O> of(Class<O> type) {
        return new Literal(type);
    }

    public abstract JSON toJSON();

    protected abstract Class<O> getType();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Wrapper<O extends MetaModelObject>
    extends Key<O> {
        private final Object value;
        private final Class<O> type;

        private Wrapper(Object value, Class<O> type) throws NullPointerException {
            if (value == null) {
                throw new NullPointerException("No null value accepted");
            }
            if (type == null) {
                throw new NullPointerException("No null type accepted");
            }
            this.value = value;
            this.type = type;
        }

        @Override
        protected Class<O> getType() {
            return this.type;
        }

        @Override
        public JSON toJSON() {
            return new JSON().set("value", this.value).set("type", this.type.getName());
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                return this.value.equals(that.value) && this.type.equals(that.type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.value.hashCode() ^ this.type.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[value=" + this.value + ",type=" + this.type.getName() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Literal<O extends MetaModelObject>
    extends Key<O> {
        private final Class<O> type;

        private Literal(Class<O> type) throws NullPointerException {
            if (type == null) {
                throw new NullPointerException("No null type accepted");
            }
            this.type = type;
        }

        @Override
        public JSON toJSON() {
            return new JSON().set("type", this.type.getName());
        }

        @Override
        protected Class<O> getType() {
            return this.type;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Literal) {
                Literal that = (Literal)obj;
                return this.type.equals(that.type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.type.hashCode();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.type.getName() + "]";
        }
    }
}

