/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.asset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyMap;
import juzu.Response;
import juzu.asset.Asset;
import juzu.asset.AssetLocation;
import juzu.asset.AssetType;
import juzu.impl.application.ApplicationException;
import juzu.impl.asset.AssetManager;
import juzu.impl.asset.AssetMetaData;
import juzu.impl.asset.Manager;
import juzu.impl.plugin.Plugin;
import juzu.impl.plugin.asset.AssetDescriptor;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.impl.utils.JSON;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetPlugin
extends Plugin
implements RequestFilter {
    private Asset[] scripts;
    private Asset[] stylesheets;
    private AssetDescriptor descriptor;
    @Inject
    @Manager(value=AssetType.SCRIPT)
    AssetManager scriptManager;
    @Inject
    @Manager(value=AssetType.STYLESHEET)
    AssetManager stylesheetManager;

    public AssetPlugin() {
        super("asset");
    }

    @Override
    public AssetDescriptor init(ClassLoader loader, JSON config) throws Exception {
        String packageName = config.getString("package");
        List<AssetMetaData> scripts = this.load(packageName, config.getList("scripts", JSON.class));
        List<AssetMetaData> stylesheets = this.load(packageName, config.getList("stylesheets", JSON.class));
        this.descriptor = new AssetDescriptor(packageName, scripts, stylesheets);
        return this.descriptor;
    }

    private List<AssetMetaData> load(String packageName, List<? extends JSON> scripts) {
        List<AssetMetaData> abc = Collections.emptyList();
        if (scripts != null && scripts.size() > 0) {
            abc = new ArrayList<AssetMetaData>();
            for (JSON jSON : scripts) {
                String id = jSON.getString("id");
                AssetLocation location = AssetLocation.safeValueOf(jSON.getString("location"));
                String value = jSON.getString("src");
                if (!value.startsWith("/") && location == AssetLocation.CLASSPATH) {
                    value = "/" + packageName.replace('.', '/') + "/" + value;
                }
                AssetMetaData descriptor = new AssetMetaData(id, location, value, jSON.getArray("depends", String.class));
                abc.add(descriptor);
            }
        }
        return abc;
    }

    @PostConstruct
    public void start() {
        ArrayList<Asset> scripts = new ArrayList<Asset>();
        for (AssetMetaData script : this.descriptor.getScripts()) {
            String id = script.getId();
            if (id != null) {
                scripts.add(Asset.ref(id));
            } else {
                scripts.add(Asset.uri(script.getLocation(), script.getValue()));
            }
            this.scriptManager.addAsset(script);
        }
        ArrayList<Asset> stylesheets = new ArrayList<Asset>();
        for (AssetMetaData stylesheet : this.descriptor.getStylesheets()) {
            String id = stylesheet.getId();
            if (id != null) {
                stylesheets.add(Asset.ref(stylesheet.getId()));
            } else {
                stylesheets.add(Asset.uri(stylesheet.getLocation(), stylesheet.getValue()));
            }
            this.stylesheetManager.addAsset(stylesheet);
        }
        this.scripts = scripts.toArray(new Asset[scripts.size()]);
        this.stylesheets = stylesheets.toArray(new Asset[stylesheets.size()]);
    }

    @Override
    public void invoke(Request request) throws ApplicationException {
        Response response;
        request.invoke();
        if (request.getContext().getPhase() == Phase.RENDER && (response = request.getResponse()) instanceof Response.Render && (this.scripts.length > 0 || this.stylesheets.length > 0)) {
            Response.Render render = (Response.Render)response;
            PropertyMap properties = new PropertyMap(render.getProperties());
            properties.addValues(Response.Render.STYLESHEET, this.stylesheets);
            properties.addValues(Response.Render.SCRIPT, this.scripts);
            request.setResponse(new Response.Render(properties, render.getStreamable()));
        }
    }
}

