/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import juzu.impl.compiler.MessageCode;
import juzu.impl.metamodel.Key;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelEvent;
import juzu.impl.metamodel.MetaModelObject;
import juzu.impl.template.metamodel.TemplateRefMetaModel;
import juzu.impl.template.metamodel.TemplatesMetaModel;
import juzu.impl.utils.JSON;
import juzu.impl.utils.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateMetaModel
extends MetaModelObject {
    public static final MessageCode CANNOT_WRITE_TEMPLATE_STUB = new MessageCode("CANNOT_WRITE_TEMPLATE_STUB", "The template stub %1$s cannot be written");
    public static final MessageCode CANNOT_WRITE_TEMPLATE_CLASS = new MessageCode("CANNOT_WRITE_TEMPLATE_CLASS", "The template class %1$s cannot be written");
    public static final MessageCode CANNOT_WRITE_APPLICATION = new MessageCode("CANNOT_WRITE_APPLICATION", "The application %1$s cannot be written");
    public static final MessageCode TEMPLATE_NOT_RESOLVED = new MessageCode("TEMPLATE_NOT_RESOLVED", "The template %1$s cannot be resolved");
    public static final MessageCode TEMPLATE_SYNTAX_ERROR = new MessageCode("TEMPLATE_SYNTAX_ERROR", "Template syntax error");
    public static final MessageCode TEMPLATE_VALIDATION_ERROR = new MessageCode("TEMPLATE_VALIDATION_ERROR", "Template validation error");
    public static final MessageCode TEMPLATE_ILLEGAL_PATH = new MessageCode("TEMPLATE_ILLEGAL_PATH", "The reference to the template %1$s is malformed");
    public static final MessageCode CANNOT_WRITE_TEMPLATE_SCRIPT = new MessageCode("CANNOT_WRITE_TEMPLATE_SCRIPT", "The template script %1$s cannot be written");
    public static final Key<TemplateMetaModel> KEY = Key.of(TemplateMetaModel.class);
    TemplatesMetaModel templates;
    final Path path;
    private int refCount = 0;

    public TemplateMetaModel(Path path) {
        this.path = path;
    }

    public TemplatesMetaModel getTemplates() {
        return this.templates;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public JSON toJSON() {
        JSON json = new JSON();
        json.set("path", this.path.getCanonical());
        json.map("refs", this.getKeys(TemplateRefMetaModel.class));
        return json;
    }

    public Collection<TemplateRefMetaModel> getRefs() {
        ArrayList<TemplateRefMetaModel> refs = new ArrayList<TemplateRefMetaModel>();
        for (MetaModelObject parent : this.getParents()) {
            if (!(parent instanceof TemplateRefMetaModel)) continue;
            refs.add((TemplateRefMetaModel)parent);
        }
        return refs;
    }

    @Override
    public boolean exist(MetaModel model) {
        return this.refCount == 0 || this.templates == null;
    }

    @Override
    protected void postAttach(MetaModelObject parent) {
        if (parent instanceof TemplatesMetaModel) {
            this.queue(MetaModelEvent.createAdded(this));
            this.templates = (TemplatesMetaModel)parent;
        } else if (parent instanceof TemplateRefMetaModel) {
            ++this.refCount;
        }
    }

    @Override
    protected void preDetach(MetaModelObject parent) {
        if (parent instanceof TemplatesMetaModel) {
            this.templates.resolver.removeTemplate(this.path);
            this.queue(MetaModelEvent.createRemoved(this, this.templates.application.getHandle()));
            this.templates = null;
        } else if (parent instanceof TemplateRefMetaModel) {
            --this.refCount;
        }
    }
}

