/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import juzu.impl.utils.ParameterMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterHashMap
extends HashMap<String, String[]>
implements ParameterMap {
    @Override
    public void setParameter(String name, String value) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null name can be used");
        }
        if (name.startsWith("juzu.")) {
            throw new IllegalArgumentException("Parameter name cannot be prefixed with juzu.");
        }
        if (value != null) {
            this.put(name, new String[]{value});
        } else {
            this.remove(name);
        }
    }

    @Override
    public void setParameter(String name, String[] value) throws NullPointerException, IllegalArgumentException {
        if (name == null) {
            throw new NullPointerException("No null name can be used");
        }
        if (value == null) {
            throw new NullPointerException("No null value can be used");
        }
        if (name.startsWith("juzu.")) {
            throw new IllegalArgumentException("Parameter name cannot be prefixed with juzu.");
        }
        if (value.length == 0) {
            this.remove(name);
        } else {
            for (String component : value) {
                if (component != null) continue;
                throw new IllegalArgumentException("Argument array cannot contain null value");
            }
            this.put(name, value.clone());
        }
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) throws NullPointerException, IllegalArgumentException {
        if (parameters == null) {
            throw new NullPointerException("No null parameters accepted");
        }
        for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("No null parameter key can be null");
            }
            if (entry.getValue() == null) {
                throw new IllegalArgumentException("No null parameter value can be null");
            }
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParameterMap) {
            ParameterMap that = (ParameterMap)o;
            if (((Object)this.keySet()).equals(that.keySet())) {
                for (Map.Entry entry : this.entrySet()) {
                    Object[] value1 = (String[])entry.getValue();
                    Object[] value2 = (String[])that.get(entry.getKey());
                    if (value2 != null && Arrays.equals(value1, value2)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            sb.append((String)entry.getKey()).append("=[");
            String[] value = (String[])entry.getValue();
            for (int j = 0; j < value.length; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(value[j]);
            }
            sb.append(']');
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb.toString();
    }
}

