/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.utils;

import java.io.Serializable;
import java.util.Iterator;
import juzu.impl.utils.Tools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QN
implements CharSequence,
Serializable,
Iterable<String> {
    public static QN EMPTY = new QN("", new String[0]);
    private final String value;
    private final String[] names;
    private int size;
    private QN parent;

    public static QN parse(CharSequence value) {
        return QN.parse(value, 0, 0);
    }

    private static QN parse(CharSequence value, int from, int size) {
        int len = value.length();
        if (from < len) {
            int to = -1;
            for (int current = from; current < len; ++current) {
                if (value.charAt(current) != '.') continue;
                to = current;
                break;
            }
            if (to == -1) {
                String[] names = new String[size + 1];
                names[size] = ((Object)value.subSequence(from, len)).toString();
                return new QN(((Object)value).toString(), names);
            }
            if (to - from < 1 || len - to < 2) {
                throw new IllegalArgumentException(" " + (to - from) + " " + (len - to));
            }
            QN that = QN.parse(value, to + 1, size + 1);
            that.names[size] = ((Object)value.subSequence(from, to)).toString();
            return that;
        }
        return new QN(((Object)value).toString(), new String[size], size);
    }

    QN(String value, String[] names) {
        this(value, names, names.length);
    }

    QN(String value, String[] names, int size) {
        this.value = value;
        this.names = names;
        this.size = size;
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public String get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index " + index + " cannot be negative");
        }
        if (index < this.size) {
            return this.names[index];
        }
        throw new IndexOutOfBoundsException("Index " + index + " cannot be greater than bound " + this.size);
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<String> iterator() {
        return Tools.iterator(0, this.size, this.names);
    }

    public QN getParent() {
        if (this.parent == null) {
            switch (this.size) {
                case 0: {
                    break;
                }
                case 1: {
                    this.parent = EMPTY;
                    break;
                }
                default: {
                    this.parent = new QN(this.value.substring(0, this.value.length() - this.names[this.size - 1].length() - 1), this.names, this.size - 1);
                }
            }
        }
        return this.parent;
    }

    public String getValue() {
        return this.value;
    }

    public QN append(QN suffix) throws NullPointerException {
        return this.append(suffix.names, suffix.size);
    }

    public QN append(String ... suffix) throws NullPointerException, IllegalArgumentException {
        return this.append(suffix, suffix.length);
    }

    private QN append(String[] suffix, int size) throws NullPointerException, IllegalArgumentException {
        if (suffix == null) {
            throw new NullPointerException("No null names accepted");
        }
        if (size == 0) {
            return this;
        }
        StringBuilder sb = new StringBuilder(this.value);
        for (int i = 0; i < size; ++i) {
            String s = suffix[i];
            if (s == null) {
                throw new IllegalArgumentException("No null name accepted");
            }
            if (s.isEmpty()) {
                throw new IllegalArgumentException("No empty name accepted");
            }
            if (s.indexOf(46) != -1) {
                throw new IllegalArgumentException("A name cannot contain a '.'");
            }
            sb.append('.');
            sb.append(s);
        }
        String[] foo = new String[this.size + suffix.length];
        System.arraycopy(this.names, 0, foo, 0, this.size);
        System.arraycopy(suffix, 0, foo, this.size, suffix.length);
        return new QN(sb.toString(), foo, foo.length);
    }

    @Override
    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean isPrefix(QN qn) {
        if (qn.parent == this) {
            return true;
        }
        if (this.size <= qn.size) {
            for (int i = 0; i < this.size; ++i) {
                if (this.names[i].equals(qn.names[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void mergeTo(String[] strings) {
        for (int i = 0; i < strings.length && strings[i] == null; ++i) {
            strings[i] = this.names[i];
        }
    }

    @Override
    public String toString() {
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof QN) {
            QN that = (QN)obj;
            return this.size == that.size && this.value.equals(that.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

