/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.request.spi.portlet;

import java.io.IOException;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceURL;
import juzu.Response;
import juzu.asset.Asset;
import juzu.impl.inject.ScopedContext;
import juzu.impl.request.spi.RenderBridge;
import juzu.impl.request.spi.portlet.PortletBridgeContext;
import juzu.impl.request.spi.portlet.PortletMimeBridge;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletRenderBridge
extends PortletMimeBridge<RenderRequest, RenderResponse>
implements RenderBridge {
    public PortletRenderBridge(PortletBridgeContext context, RenderRequest request, RenderResponse response, boolean buffer, boolean prod) {
        super(context, request, response, buffer, prod);
    }

    @Override
    public void setTitle(String title) {
        ((RenderResponse)this.resp).setTitle(title);
    }

    @Override
    public void end(Response response) throws IllegalStateException, IOException {
        if (response instanceof Response.Render) {
            Response.Render render = (Response.Render)response;
            if (!((RenderRequest)this.req).getPortalContext().getPortalInfo().startsWith("GateIn Portlet Container")) {
                // empty if block
            }
            Iterable<Asset.Value> scripts = this.context.assetManager.resolveAssets(render.getScripts());
            Iterable<Asset.Value> stylesheets = this.context.assetManager.resolveAssets(render.getStylesheets());
            for (Asset.Value stylesheet : stylesheets) {
                int pos = stylesheet.getURI().lastIndexOf(46);
                String ext = pos == -1 ? "css" : stylesheet.getURI().substring(pos + 1);
                Element elt = ((RenderResponse)this.resp).createElement("link");
                elt.setAttribute("media", "screen");
                elt.setAttribute("rel", "stylesheet");
                elt.setAttribute("type", "text/" + ext);
                elt.setAttribute("href", this.getAssetURL(stylesheet));
                ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
            }
            for (Asset.Value script : scripts) {
                String url = this.getAssetURL(script);
                Element elt = ((RenderResponse)this.resp).createElement("script");
                elt.setAttribute("type", "text/javascript");
                elt.setAttribute("src", url);
                Comment comment = elt.getOwnerDocument().createComment(this.request.getApplication().getName() + " script ");
                elt.appendChild(comment);
                ((RenderResponse)this.resp).addProperty("javax.portlet.markup.head.element", elt);
            }
            String title = render.getTitle();
            if (title != null) {
                this.setTitle(title);
            }
        }
        super.end(response);
    }

    private String getAssetURL(Asset.Value asset) {
        String url;
        String uri = asset.getURI();
        switch (asset.getLocation()) {
            case SERVER: {
                StringBuilder sb = new StringBuilder();
                if (!uri.startsWith("/")) {
                    sb.append(((RenderRequest)this.req).getContextPath());
                    sb.append('/');
                }
                sb.append(uri);
                url = sb.toString();
                break;
            }
            case CLASSPATH: {
                if (this.prod) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(((RenderRequest)this.req).getContextPath()).append("/assets");
                    if (!uri.startsWith("/")) {
                        sb.append('/');
                    }
                    sb.append(uri);
                    url = sb.toString();
                    break;
                }
                ResourceURL r = ((RenderResponse)this.resp).createResourceURL();
                r.setParameter("juzu.request", "assets");
                r.setResourceID(uri);
                url = r.toString();
                break;
            }
            case EXTERNAL: {
                url = uri;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return url;
    }

    @Override
    public void close() {
        ScopedContext context = this.getFlashContext(false);
        if (context != null) {
            context.close();
        }
    }
}

