/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.template.spi.juzu.ast;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import juzu.impl.common.Builder;
import juzu.impl.template.spi.juzu.ast.ASTNode;
import juzu.impl.template.spi.juzu.ast.ParseException;
import juzu.impl.template.spi.juzu.ast.SectionType;
import juzu.test.AbstractTestCase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParserTestCase
extends AbstractTestCase {
    private List<ASTNode.Block<?>> parse(String s) {
        try {
            return ASTNode.Template.parse((CharSequence)s).getChildren();
        }
        catch (ParseException e) {
            throw TemplateParserTestCase.failure(e);
        }
    }

    @Test
    public void testEmpty() throws IOException {
        TemplateParserTestCase.assertEquals(Collections.emptyList(), this.parse(""));
    }

    @Test
    public void testText() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.STRING, "a")), this.parse("a"));
    }

    @Test
    public void testSingleEmptyScriplet() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.SCRIPTLET, "")), this.parse("<%%>"));
    }

    @Test
    public void testSingleEmptyExpression() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.EXPR, "")), this.parse("<%=%>"));
    }

    @Test
    public void testSingleScriplet() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.SCRIPTLET, "a")), this.parse("<%a%>"));
    }

    @Test
    public void testSingleExpression() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.EXPR, "a")), this.parse("<%=a%>"));
    }

    @Test
    public void testPercentScriplet() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.SCRIPTLET, "%")), this.parse("<%%%>"));
    }

    @Test
    public void testPercentExpression() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.EXPR, "%")), this.parse("<%=%%>"));
    }

    @Test
    public void testStartAngleBracketScriplet() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.SCRIPTLET, "<")), this.parse("<%<%>"));
    }

    @Test
    public void testStartAngleBracketExpression() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.EXPR, "<")), this.parse("<%=<%>"));
    }

    @Test
    public void testCurlyExpression() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.EXPR, "a")), this.parse("${a}"));
    }

    @Test
    public void testParseURL() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.emptyMap())), this.parse("@{a()}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.singletonMap("a", "b"))), this.parse("@{a(a=b)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"b").map((Object)"c", (Object)"d").build())), this.parse("@{a(a=b,c=d)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.emptyMap())), this.parse("@{a( )}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.singletonMap("a", "b"))), this.parse("@{a( a=b)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.singletonMap("a", "b"))), this.parse("@{a(a =b)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.singletonMap("a", "b"))), this.parse("@{a(a= b)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Collections.singletonMap("a", "b"))), this.parse("@{a(a=b )}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"b").map((Object)"c", (Object)"d").build())), this.parse("@{a(a=b ,c=d)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"b").map((Object)"c", (Object)"d").build())), this.parse("@{a(a=b, c=d)}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"'b '").build())), this.parse("@{a(a='b ')}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"'b '").build())), this.parse("@{a(a= 'b ' )}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"\"b \"").build())), this.parse("@{a(a=\"b \")}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL(null, "a", Builder.map((Object)"a", (Object)"\"b \"").build())), this.parse("@{a(a= \"b \" )}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.URL("a", "b", Collections.emptyMap())), this.parse("@{a.b()}"));
    }

    @Test
    public void testParseTag() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Tag("foo")), this.parse("#{foo/}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Tag("foo")), this.parse("#{foo /}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Tag("foo", Collections.singletonMap("a", "b"))), this.parse("#{foo a=b/}"));
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Tag("foo", Collections.singletonMap("a", "b"))), this.parse("#{foo a=b /}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo").addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo}#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo").addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo }#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo").addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo}#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo", Collections.singletonMap("a", "b")).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo a=b}#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo", Collections.singletonMap("a", "b")).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo a =b}#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo", Collections.singletonMap("a", "b")).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo a= b}#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo", Collections.singletonMap("a", "b")).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo a=b }#{/foo}"));
        TemplateParserTestCase.assertEquals(Arrays.asList((ASTNode.Block)new ASTNode.Tag("foo", Collections.singletonMap("a", " ")).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, ""))), this.parse("#{foo a=' '}#{/foo}"));
    }

    @Test
    public void testParseNestedTag() throws IOException, ParseException {
        List<ASTNode.Block<?>> o = this.parse("#{foo} ${bar} #{/foo}");
        List<ASTNode> expected = Collections.singletonList(((ASTNode.Tag)((ASTNode.Tag)new ASTNode.Tag("foo").addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, " "))).addChild((ASTNode.Block)new ASTNode.Section(SectionType.EXPR, "bar"))).addChild((ASTNode.Block)new ASTNode.Section(SectionType.STRING, " ")));
        TemplateParserTestCase.assertEquals(expected, o);
    }

    @Test
    public void testSimpleScript() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.STRING, "a"), new ASTNode.Section(SectionType.SCRIPTLET, "b"), new ASTNode.Section(SectionType.STRING, "c")), this.parse("a<%b%>c"));
    }

    @Test
    public void testSimpleScript2() throws IOException {
        TemplateParserTestCase.assertEquals(Arrays.asList(new ASTNode.Section(SectionType.STRING, "a"), new ASTNode.Section(SectionType.EXPR, "b"), new ASTNode.Section(SectionType.STRING, "c")), this.parse("a<%=b%>c"));
    }

    @Test
    public void testWindowsLineBreak() throws IOException {
    }
}

