/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.web.WebActionBridge;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.bridge.spi.web.WebRenderBridge;
import juzu.impl.bridge.spi.web.WebRequestBridge;
import juzu.impl.bridge.spi.web.WebResourceBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.Tools;
import juzu.impl.common.URIWriter;
import juzu.impl.plugin.router.RouteDescriptor;
import juzu.impl.request.Method;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.request.Phase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Handler
implements Closeable {
    private static final Phase[] GET_PHASES = new Phase[]{Phase.VIEW, Phase.ACTION, Phase.RESOURCE};
    private static final Phase[] POST_PHASES = new Phase[]{Phase.ACTION, Phase.VIEW, Phase.RESOURCE};
    final Bridge bridge;
    final Route root;
    final HashMap<MethodHandle, Route> forwardRoutes;
    final HashMap<Route, Map<Phase, MethodHandle>> backwardRoutes;

    public Handler(Bridge bridge) throws Exception {
        Route root;
        this.bridge = bridge;
        bridge.refresh();
        HashMap<MethodHandle, Route> forwardRoutes = new HashMap<MethodHandle, Route>();
        HashMap<Route, HashMap<Phase, MethodHandle>> backwardRoutes = new HashMap<Route, HashMap<Phase, MethodHandle>>();
        RouteDescriptor routesDesc = (RouteDescriptor)bridge.application.getDescriptor().getPluginDescriptor("router");
        if (routesDesc != null) {
            Map<RouteDescriptor, Route> ret = routesDesc.create();
            root = ret.values().iterator().next();
            for (Map.Entry<RouteDescriptor, Route> entry : ret.entrySet()) {
                for (Map.Entry<String, String> entry2 : entry.getKey().getTargets().entrySet()) {
                    MethodHandle handle = MethodHandle.parse(entry2.getValue());
                    Phase phase = Phase.valueOf(entry2.getKey());
                    forwardRoutes.put(handle, entry.getValue());
                    HashMap<Phase, MethodHandle> map = (HashMap<Phase, MethodHandle>)backwardRoutes.get(entry.getValue());
                    if (map == null) {
                        map = new HashMap<Phase, MethodHandle>();
                        backwardRoutes.put(entry.getValue(), map);
                    }
                    map.put(phase, handle);
                }
            }
        } else {
            root = new Router();
        }
        this.forwardRoutes = forwardRoutes;
        this.backwardRoutes = backwardRoutes;
        this.root = root;
    }

    public Map<Phase, MethodHandle> getMethods(Route route) {
        return this.backwardRoutes.get(route);
    }

    public Route getRoute(MethodHandle method) {
        return this.forwardRoutes.get(method);
    }

    public Route getRoot() {
        return this.root;
    }

    public Bridge getBridge() {
        return this.bridge;
    }

    public void handle(WebBridge bridge) throws Throwable {
        Map<Phase, MethodHandle> m;
        String requestPath = bridge.getRequestPath();
        RouteMatch requestMatch = null;
        if (requestPath.startsWith(bridge.getPath())) {
            requestMatch = this.root.route(requestPath.substring(bridge.getPath().length()), Collections.<String, String[]>emptyMap());
        }
        Method requestMethod = null;
        Map<String, String[]> requestParameters = Collections.emptyMap();
        if (requestMatch != null && (m = this.getMethods(requestMatch.getRoute())) != null) {
            Phase[] phases;
            if ("GET".equals(bridge.getHttpContext().getMethod())) {
                phases = GET_PHASES;
            } else if ("POST".equals(bridge.getHttpContext().getMethod())) {
                phases = POST_PHASES;
            } else {
                throw new UnsupportedOperationException("handle me gracefully");
            }
            for (Phase phase : phases) {
                MethodHandle handle = m.get(phase);
                if (handle == null) continue;
                requestMethod = this.bridge.application.getDescriptor().getControllers().getMethodByHandle(handle);
                if (requestMatch.getMatched().size() <= 0 && bridge.getParameters().size() <= 0) break;
                requestParameters = new HashMap<String, String[]>();
                for (Map.Entry<String, String[]> entry : bridge.getParameters().entrySet()) {
                    requestParameters.put(entry.getKey(), (String[])entry.getValue().clone());
                }
                for (Map.Entry<Object, Object> entry : requestMatch.getMatched().entrySet()) {
                    requestParameters.put(((PathParam)entry.getKey()).getName(), new String[]{(String)entry.getValue()});
                }
                break;
            }
        }
        if (requestMethod == null) {
            requestMethod = this.bridge.application.getDescriptor().getControllers().getResolver().resolve(Phase.VIEW, Collections.<String>emptySet());
        }
        if (requestMethod == null) {
            bridge.setStatus(404);
        } else {
            Response response;
            WebRequestBridge requestBridge;
            Route requestRoute;
            if (requestMatch == null && (requestRoute = this.getRoute(requestMethod.getHandle())) != null && (requestMatch = requestRoute.matches(Collections.<String, String>emptyMap())) != null) {
                StringBuilder sb = new StringBuilder();
                requestMatch.render(new URIWriter(sb));
                if (!sb.toString().equals(requestPath)) {
                    StringBuilder redirect = new StringBuilder();
                    bridge.renderRequestURL(redirect);
                    redirect.append((CharSequence)sb);
                    bridge.sendRedirect(redirect.toString());
                    return;
                }
            }
            if (requestMethod.getPhase() == Phase.ACTION) {
                requestBridge = new WebActionBridge(this.bridge.application.getApplication(), this, bridge, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.VIEW) {
                requestBridge = new WebRenderBridge(this.bridge.application.getApplication(), this, bridge, requestMethod, requestParameters);
            } else if (requestMethod.getPhase() == Phase.RESOURCE) {
                requestBridge = new WebResourceBridge(this.bridge.application.getApplication(), this, bridge, requestMethod, requestParameters);
            } else {
                throw new Exception("Cannot decode phase");
            }
            this.bridge.invoke(requestBridge);
            if (requestBridge instanceof WebActionBridge && (response = ((WebActionBridge)requestBridge).response) instanceof Response.View) {
                Response.View update = (Response.View)response;
                Boolean redirect = response.getProperties().getValue(PropertyType.REDIRECT_AFTER_ACTION);
                if (redirect != null && !redirect.booleanValue()) {
                    Method desc = this.bridge.application.getDescriptor().getControllers().getMethodByHandle(update.getTarget());
                    requestBridge = new WebRenderBridge(this.bridge.application.getApplication(), this, bridge, desc, update.getParameters());
                    this.bridge.invoke(requestBridge);
                }
            }
            requestBridge.send();
        }
    }

    @Override
    public void close() throws IOException {
        Tools.safeClose(this.bridge);
    }
}

