/*
 * Decompiled with CFR 0.152.
 */
package juzu.template;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import juzu.PropertyMap;
import juzu.Response;
import juzu.UndeclaredIOException;
import juzu.impl.common.Path;
import juzu.impl.plugin.application.Application;
import juzu.impl.plugin.application.ApplicationException;
import juzu.impl.plugin.template.TemplatePlugin;
import juzu.impl.request.Request;
import juzu.impl.template.spi.TemplateStub;
import juzu.impl.template.spi.juzu.dialect.gtmpl.MessageKey;
import juzu.io.AppendableStream;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.request.ApplicationContext;
import juzu.request.MimeContext;
import juzu.request.RequestContext;
import juzu.template.TemplateExecutionException;
import juzu.template.TemplateRenderContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Template {
    private final Path path;
    private final TemplatePlugin plugin;
    private final Class<? extends TemplateStub> stubType;
    @Inject
    Application application;

    public Template(TemplatePlugin plugin, String path, Class<? extends TemplateStub> stubType) {
        this(plugin, Path.parse(path), stubType);
    }

    public Template(TemplatePlugin plugin, Path path, Class<? extends TemplateStub> stubType) {
        this.plugin = plugin;
        this.path = path;
        this.stubType = stubType;
    }

    public final Path getPath() {
        return this.path;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[path=" + this.path + "]";
    }

    public void render() throws TemplateExecutionException, UndeclaredIOException {
        this.with().render();
    }

    public void render(Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.with(locale).render();
    }

    public void render(Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.with(parameters).render();
    }

    public void render(Map<String, ?> parameters, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.with(parameters).locale(locale).render();
    }

    public final Response.Render ok() {
        return this.with().ok();
    }

    public final Response.Render ok(Locale locale) {
        return this.with(locale).ok();
    }

    public final Response.Render ok(Map<String, ?> parameters) {
        return this.with(parameters).ok();
    }

    public final Response.Render ok(Map<String, ?> parameters, Locale locale) {
        return this.with(parameters).locale(locale).ok();
    }

    public final Response.Render notFound() {
        return this.notFound(null, null);
    }

    public final Response.Render notFound(Locale locale) {
        return this.notFound(null, locale);
    }

    public final Response.Render notFound(Map<String, ?> parameters) {
        return this.notFound(parameters, null);
    }

    public final Response.Render notFound(Map<String, ?> parameters, Locale locale) {
        return this.with(parameters).locale(locale).notFound();
    }

    public <A extends Appendable> A renderTo(A appendable) throws TemplateExecutionException, UndeclaredIOException {
        return this.with().renderTo(appendable);
    }

    public <A extends Appendable> A renderTo(A appendable, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        return this.with(locale).renderTo(appendable);
    }

    public <A extends Appendable> A renderTo(A appendable, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        return this.with(parameters).renderTo(appendable);
    }

    public void renderTo(Stream.Char printer) throws TemplateExecutionException, UndeclaredIOException {
        this.with().renderTo(printer);
    }

    public void renderTo(Stream.Char printer, Locale locale) throws TemplateExecutionException, UndeclaredIOException {
        this.with(locale).renderTo(printer);
    }

    public void renderTo(Stream.Char printer, Map<String, ?> parameters) throws TemplateExecutionException, UndeclaredIOException {
        this.with(parameters).renderTo(printer);
    }

    protected abstract Builder builder();

    public Builder with() {
        return this.builder();
    }

    public Builder with(Map<String, ?> parameters) {
        Builder builder = this.with();
        builder.parameters = parameters;
        return builder;
    }

    public Builder with(Locale locale) {
        Builder builder = this.with();
        builder.locale = locale;
        return builder;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Builder {
        private Map<String, Object> parameters;
        private Locale locale;

        private Locale computeLocale() {
            if (this.locale == null) {
                return Request.getCurrent().getContext().getUserContext().getLocale();
            }
            return this.locale;
        }

        private void doRender(PropertyMap properties, Stream.Char stream) {
            try {
                final Locale locale = this.computeLocale();
                TemplateStub stub = Template.this.plugin.resolveTemplateStub(Template.this.path);
                if (stub == null) {
                    throw new UnsupportedOperationException("Handle me gracefully: couldn't get stub for template " + Template.this.path);
                }
                TemplateRenderContext context = new TemplateRenderContext(stub, properties, this.parameters, locale){
                    ResourceBundle bundle;
                    boolean bundleLoaded;
                    {
                        super(x0, x1, x2, x3);
                        this.bundle = null;
                        this.bundleLoaded = false;
                    }

                    public TemplateStub resolveTemplate(String path) {
                        return Template.this.plugin.resolveTemplateStub(path);
                    }

                    public Object resolveBean(String expression) throws ApplicationException {
                        return Template.this.application.resolveBean(expression);
                    }

                    public String resolveMessage(MessageKey key) {
                        if (!this.bundleLoaded) {
                            ApplicationContext applicationContext;
                            this.bundleLoaded = true;
                            if (locale != null && (applicationContext = Request.getCurrent().getContext().getApplicationContext()) != null) {
                                this.bundle = applicationContext.resolveBundle(locale);
                            }
                        }
                        String value = null;
                        if (this.bundle != null) {
                            try {
                                value = this.bundle.getString(key.getValue());
                            }
                            catch (MissingResourceException notFound) {
                                System.out.println("Could not resolve message " + key.getValue());
                            }
                        }
                        return value != null ? value : "";
                    }
                };
                context.render(stream);
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder set(String name, Object value) throws NullPointerException {
            if (name == null) {
                throw new NullPointerException("The parameter argument cannot be null");
            }
            if (value != null) {
                if (this.parameters == null) {
                    this.parameters = new HashMap<String, Object>();
                }
                this.parameters.put(name, value);
            } else if (this.parameters != null) {
                this.parameters.remove(name);
            }
            return this;
        }

        public final Response.Render ok() {
            return this.status(200);
        }

        public final Response.Render notFound() {
            return this.status(404);
        }

        public final Response.Render status(int status) {
            StringBuilder sb = new StringBuilder();
            PropertyMap properties = new PropertyMap();
            this.doRender(properties, new AppendableStream(sb));
            return new Response.Render(status, properties, new Streamable.CharSequence(sb));
        }

        public <A extends Appendable> A renderTo(A appendable) throws TemplateExecutionException, UndeclaredIOException {
            this.renderTo(new AppendableStream(appendable));
            return appendable;
        }

        public void renderTo(Stream.Char printer) throws TemplateExecutionException, UndeclaredIOException {
            if (printer == null) {
                throw new NullPointerException("No null printe provided");
            }
            this.doRender(null, printer);
        }

        public void render() throws TemplateExecutionException, UndeclaredIOException {
            try {
                RequestContext context = Request.getCurrent().getContext();
                if (!(context instanceof MimeContext)) {
                    throw new AssertionError((Object)"does not make sense");
                }
                MimeContext mime = (MimeContext)context;
                Response.Render render = this.status(200);
                mime.setResponse(render);
            }
            catch (IOException e) {
                throw new UndeclaredIOException(e);
            }
        }
    }
}

