/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import juzu.io.CharArray;
import juzu.io.Stream;

public class AppendableStream
implements Stream.Char {
    protected final Appendable delegate;

    public AppendableStream(Appendable delegate) {
        if (delegate == null) {
            throw new NullPointerException("No null writer accepted");
        }
        this.delegate = delegate;
    }

    public Stream.Char append(char c) throws IOException {
        this.delegate.append(c);
        return this;
    }

    public Stream.Char append(CharSequence s) throws IOException {
        this.delegate.append(s);
        return this;
    }

    public Stream.Char append(CharSequence csq, int start, int end) throws IOException {
        this.delegate.append(csq, start, end);
        return this;
    }

    public Stream.Char append(CharArray chars) throws IOException {
        chars.write(this.delegate);
        return this;
    }

    public void close() throws IOException {
        if (this.delegate instanceof Closeable) {
            ((Closeable)((Object)this.delegate)).close();
        }
    }

    public void flush() throws IOException {
        if (this.delegate instanceof Flushable) {
            ((Flushable)((Object)this.delegate)).flush();
        }
    }
}

