/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.disk;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import juzu.impl.common.Content;
import juzu.impl.common.Name;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.FilterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskFileSystem
extends ReadWriteFileSystem<File> {
    private final File root;
    private FilenameFilter filter;
    private Charset encoding;

    public DiskFileSystem(File root) {
        this(root, new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return true;
            }
        });
    }

    public DiskFileSystem(File root, FilenameFilter filter) {
        this.root = root;
        this.filter = filter;
        this.encoding = Charset.defaultCharset();
    }

    public DiskFileSystem(File root, Name path) {
        this(root, new FilterImpl(root, path));
    }

    public DiskFileSystem(File root, String path) {
        this(root, new FilterImpl(root, Name.parse(path)));
    }

    public void applyFilter(String path) {
        this.filter = new FilterImpl(this.root, Name.parse(path));
    }

    @Override
    public Class<File> getType() {
        return File.class;
    }

    @Override
    public String getDescription() {
        return "disk[" + this.root.getAbsolutePath() + "]";
    }

    @Override
    public boolean equals(File left, File right) {
        return left.equals(right);
    }

    @Override
    public File getRoot() throws IOException {
        return this.root;
    }

    @Override
    public PathType typeOf(File path) throws IOException {
        if (path.isDirectory()) {
            return PathType.DIR;
        }
        if (path.isFile()) {
            return PathType.FILE;
        }
        return null;
    }

    @Override
    public String getName(File path) throws IOException {
        if (path.equals(this.root)) {
            return "";
        }
        return path.getName();
    }

    @Override
    public Iterator<File> getChildren(File dir) throws IOException {
        File[] children = dir.listFiles(this.filter);
        return children == null ? Tools.emptyIterator() : Arrays.asList(children).iterator();
    }

    @Override
    public File getChild(File dir, String name) throws IOException {
        File child;
        if (this.filter.accept(dir, name) && (child = new File(dir, name)).exists()) {
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamped<Content> getContent(File file) throws IOException {
        Timestamped<Content> timestamped;
        FileInputStream in = new FileInputStream(file);
        try {
            ByteArrayOutputStream content = new ByteArrayOutputStream();
            byte[] buffer = new byte[256];
            int l = in.read(buffer);
            while (l != -1) {
                content.write(buffer, 0, l);
                l = in.read(buffer);
            }
            timestamped = new Timestamped<Content>(file.lastModified(), new Content(content.toByteArray(), this.encoding));
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return timestamped;
    }

    @Override
    public long getLastModified(File path) throws IOException {
        return path.lastModified();
    }

    @Override
    public URL getURL(File path) throws IOException {
        return path.toURI().toURL();
    }

    @Override
    public File getFile(File path) {
        return path;
    }

    @Override
    public File makePath(File parent, String name) throws IOException {
        return new File(parent, name);
    }

    @Override
    public void createDir(File dir) throws IOException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new IOException("Dir already exists and is a file " + dir.getCanonicalPath());
            }
        } else if (!dir.mkdirs()) {
            throw new IOException("Could not create dir " + dir.getCanonicalPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setContent(File file, Content content) throws IOException {
        File parent = file.getParentFile();
        if (parent != null && !parent.exists() && !parent.mkdirs()) {
            throw new IOException("Could not create parent directory " + parent.getCanonicalPath());
        }
        InputStream in = content.getInputStream();
        FileOutputStream out = new FileOutputStream(file);
        try {
            Tools.copy(in, out);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
        return file.lastModified();
    }

    @Override
    public void removePath(File path) throws IOException {
        path.delete();
    }

    public String toString() {
        return "DiskFileSystem[root=" + this.root.getAbsolutePath() + "]";
    }
}

