/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.metamodel;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import juzu.impl.common.Name;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.compiler.ProcessingException;
import juzu.impl.metamodel.AnnotationChange;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.metamodel.EventQueue;
import juzu.impl.metamodel.MetaModel;
import juzu.impl.metamodel.MetaModelPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MetaModelContext<P extends MetaModelPlugin<M, P>, M extends MetaModel<P, M>>
implements Serializable,
Iterable<M> {
    private ProcessingContext processingContext;
    private ArrayList<M> metaModels;
    private final LinkedHashMap<String, P> plugins = new LinkedHashMap();
    private Set<Class<? extends Annotation>> supportedAnnotations;
    private final Class<P> pluginType;
    final LinkedHashMap<AnnotationKey, AnnotationState> knownAnnotations = new LinkedHashMap();

    public MetaModelContext(Class<P> pluginType) {
        this.pluginType = pluginType;
        this.metaModels = new ArrayList();
    }

    public void init(ProcessingContext env) throws NullPointerException {
        this.processingContext = env;
        LinkedHashMap<String, MetaModelPlugin> plugins = new LinkedHashMap<String, MetaModelPlugin>();
        StringBuilder msg = new StringBuilder("Using plugins:");
        for (MetaModelPlugin plugin : env.loadServices(this.pluginType)) {
            msg.append(" ").append(plugin.getName());
            plugins.put(plugin.getName(), plugin);
        }
        env.log(msg);
        HashSet<Class<? extends Annotation>> supportedAnnotations = new HashSet<Class<? extends Annotation>>();
        for (MetaModelPlugin plugin : plugins.values()) {
            Set<Class<Annotation>> processed = plugin.init(env);
            env.log("Plugin " + plugin.getName() + " wants to process " + processed);
            supportedAnnotations.addAll(processed);
        }
        this.plugins.putAll(plugins);
        this.supportedAnnotations = supportedAnnotations;
    }

    @Override
    public Iterator<M> iterator() {
        return this.metaModels.iterator();
    }

    public Set<Class<? extends Annotation>> getSupportedAnnotations() {
        return this.supportedAnnotations;
    }

    public Collection<P> getPlugins() {
        return this.plugins.values();
    }

    public void add(M metaModel) {
        ((MetaModel)metaModel).processingContext = this.processingContext;
        ((MetaModel)metaModel).forward = true;
        ((MetaModel)metaModel).context = this;
        ((MetaModel)metaModel).init(this.processingContext);
        for (MetaModelPlugin plugin : this.plugins.values()) {
            plugin.init(metaModel);
        }
        this.metaModels.add(metaModel);
    }

    public final void postActivate(ProcessingContext processingContext) throws NullPointerException {
        this.processingContext = processingContext;
        for (MetaModel metaModel : this.metaModels) {
            metaModel.processingContext = processingContext;
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.postActivate(metaModel);
            }
        }
    }

    public void processAnnotationChanges(Iterable<AnnotationChange> delta) {
        for (AnnotationChange change : delta) {
            if (change.getAdded() == null) {
                this.knownAnnotations.remove(change.getKey());
                continue;
            }
            this.knownAnnotations.put(change.getKey(), change.getAdded());
        }
        ArrayList<AnnotationChange> all = new ArrayList<AnnotationChange>();
        for (Map.Entry<AnnotationKey, AnnotationState> annotation : this.knownAnnotations.entrySet()) {
            all.add(new AnnotationChange(annotation.getKey(), null, annotation.getValue()));
        }
        for (MetaModel metaModel : this.metaModels) {
            Iterable<AnnotationChange> changes;
            if (metaModel.forward) {
                metaModel.forward = false;
                changes = all;
            } else {
                changes = delta;
            }
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.processAnnotationChanges(metaModel, changes);
            }
        }
    }

    void processAnnotations(Iterable<Map.Entry<AnnotationKey, AnnotationState>> annotations) {
        ArrayList<AnnotationChange> delta = new ArrayList<AnnotationChange>();
        for (Map.Entry<AnnotationKey, AnnotationState> entry : this.knownAnnotations.entrySet()) {
            AnnotationKey key = entry.getKey();
            Object element = this.processingContext.get(key.element);
            if (element == null) {
                delta.add(new AnnotationChange(key, entry.getValue(), null));
                continue;
            }
            AnnotationMirror found = null;
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                Name f = Name.parse(((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString());
                if (!key.getType().equals(f)) continue;
                found = annotationMirror;
                break;
            }
            if (found != null) continue;
            delta.add(new AnnotationChange(key, entry.getValue(), null));
        }
        for (Map.Entry<AnnotationKey, AnnotationState> annotation : annotations) {
            delta.add(new AnnotationChange(annotation.getKey(), this.knownAnnotations.get(annotation.getKey()), annotation.getValue()));
        }
        this.processAnnotationChanges(delta);
    }

    public void postProcessAnnotations() throws ProcessingException {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.postProcessAnnotations(metaModel);
            }
        }
    }

    public void processEvents() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.processEvents(metaModel, new EventQueue(metaModel.dispatch));
            }
            metaModel.dispatch.clear();
        }
    }

    public void postProcessEvents() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.postProcessEvents(metaModel);
            }
        }
    }

    public void prePassivate() {
        for (MetaModel metaModel : this.metaModels) {
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.prePassivate(metaModel);
            }
            metaModel.processingContext = null;
        }
        this.processingContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(M metaModel) {
        try {
            ((MetaModel)metaModel).processingContext = this.processingContext;
            this.metaModels.remove(metaModel);
            for (MetaModelPlugin plugin : this.plugins.values()) {
                plugin.destroy(metaModel);
            }
        }
        finally {
            ((MetaModel)metaModel).processingContext = null;
        }
    }
}

