/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.metadata.Descriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.descriptor.ControllersDescriptor;
import juzu.impl.plugin.template.metadata.TemplatesDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends Descriptor {
    private final Class<?> applicationClass;
    private final String packageName;
    private final String name;
    private final Class<?> packageClass;
    private final ControllersDescriptor controllers;
    private final TemplatesDescriptor templates;
    private final Map<String, Descriptor> pluginDescriptors;
    private final Map<String, ApplicationPlugin> plugins;

    public static ApplicationDescriptor create(Class<?> applicationClass) throws Exception {
        return new ApplicationDescriptor(applicationClass);
    }

    public ApplicationDescriptor(Class<?> applicationClass) throws Exception {
        String name;
        Class<?> packageClass;
        JSON config;
        InputStream in = null;
        try {
            try {
                in = applicationClass.getResourceAsStream("config.json");
                String s = Tools.read(in);
                config = (JSON)JSON.parse(s);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        try {
            packageClass = applicationClass.getClassLoader().loadClass(applicationClass.getPackage().getName() + ".package-info");
        }
        catch (ClassNotFoundException e) {
            AssertionError ae = new AssertionError((Object)"Cannot load package class");
            ((Throwable)((Object)ae)).initCause(e);
            throw ae;
        }
        HashMap<String, ApplicationPlugin> pluginMap = new HashMap<String, ApplicationPlugin>();
        for (ApplicationPlugin plugin : ServiceLoader.load(ApplicationPlugin.class)) {
            pluginMap.put(plugin.getName(), plugin);
        }
        this.applicationClass = applicationClass;
        this.name = applicationClass.getSimpleName();
        this.packageName = applicationClass.getPackage().getName();
        this.packageClass = packageClass;
        HashSet<String> names = new HashSet<String>(config.names());
        HashMap<ApplicationPlugin, JSON> configs = new HashMap<ApplicationPlugin, JSON>();
        for (ApplicationPlugin plugin : pluginMap.values()) {
            name = plugin.getName();
            if (names.remove(name)) {
                configs.put(plugin, config.getJSON(plugin.getName()));
                continue;
            }
            configs.put(plugin, null);
        }
        if (names.size() > 0) {
            throw new UnsupportedOperationException("Handle me gracefully : missing plugin " + this.name);
        }
        HashMap<String, Descriptor> pluginDescriptors = new HashMap<String, Descriptor>();
        for (Map.Entry entry : configs.entrySet()) {
            ApplicationPlugin plugin = (ApplicationPlugin)entry.getKey();
            Descriptor descriptor = plugin.init(this, (JSON)entry.getValue());
            if (descriptor == null) continue;
            pluginDescriptors.put(plugin.getName(), descriptor);
        }
        Iterator i = pluginMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            if (pluginDescriptors.containsKey(name)) continue;
            i.remove();
        }
        this.templates = (TemplatesDescriptor)pluginDescriptors.get("template");
        this.controllers = (ControllersDescriptor)pluginDescriptors.get("controller");
        this.pluginDescriptors = pluginDescriptors;
        this.plugins = pluginMap;
    }

    public Map<String, ApplicationPlugin> getPlugins() {
        return this.plugins;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        ArrayList<BeanDescriptor> beans = new ArrayList<BeanDescriptor>();
        for (Descriptor descriptor : this.pluginDescriptors.values()) {
            Tools.addAll(beans, descriptor.getBeans());
        }
        return beans;
    }

    public Descriptor getPluginDescriptor(String name) {
        return this.pluginDescriptors.get(name);
    }

    public void addPlugin(ApplicationPlugin plugin) throws Exception {
        this.plugins.put(plugin.getName(), plugin);
        this.pluginDescriptors.put(this.name, plugin.init(this, new JSON()));
    }

    public Class<?> getPackageClass() {
        return this.packageClass;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public ClassLoader getApplicationLoader() {
        return this.applicationClass.getClassLoader();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }

    public ControllersDescriptor getControllers() {
        return this.controllers;
    }

    public TemplatesDescriptor getTemplates() {
        return this.templates;
    }
}

