/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.binding;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import juzu.impl.common.JSON;
import juzu.impl.common.Name;
import juzu.impl.compiler.ElementHandle;
import juzu.impl.compiler.MessageCode;
import juzu.impl.compiler.ProcessingContext;
import juzu.impl.metamodel.AnnotationKey;
import juzu.impl.metamodel.AnnotationState;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModel;
import juzu.impl.plugin.application.metamodel.ApplicationMetaModelPlugin;
import juzu.inject.ProviderFactory;
import juzu.plugin.binding.Bindings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingMetaModelPlugin
extends ApplicationMetaModelPlugin {
    public static final MessageCode BEAN_INVALID_TYPE = new MessageCode("BINDING_BEAN_INVALID_TYPE", "The binding bean %1$s must be a class");
    public static final MessageCode BEAN_ABSTRACT_TYPE = new MessageCode("BINDING_BEAN_ABSTRACT_TYPE", "The binding bean %1$s must not be abstract");
    public static final MessageCode IMPLEMENTATION_NOT_ASSIGNABLE = new MessageCode("BINDING_IMPLEMENTATION_NOT_ASSIGNABLE", "The binding implementation type %1$s does not extend or implement the %2$s type");
    public static final MessageCode PROVIDER_NOT_ASSIGNABLE = new MessageCode("BINDING_PROVIDER_NOT_ASSIGNABLE", "The binding implementation type %1$s must provides a type %2$s that extends the %3$s type");
    public static final MessageCode IMPLEMENTATION_NOT_ABSTRACT = new MessageCode("BINDING_PROVIDER_FACTORY_NOT_ABSTRACT", "The binding implementation provider factory %1$s must not be abstract");
    public static final MessageCode PROVIDER_FACTORY_NOT_PUBLIC = new MessageCode("BINDING_IMPLEMENTATION_NOT_PUBLIC", "The binding implementation provider factory %1$s must be public");
    public static final MessageCode IMPLEMENTATION_INVALID_TYPE = new MessageCode("BINDING_IMPLEMENTATION_INVALID_TYPE", "The binding implementation provider factory %1$s must be a class");
    public static final MessageCode PROVIDER_FACTORY_NO_ZERO_ARG_CTOR = new MessageCode("BINDING_PROVIDER_FACTORY_NO_ZERO_ARG_CTOR", "The binding implementation provider factory %1$s must provides a public zero argument constructor");
    public static final MessageCode PROVIDER_FACTORY_NO_PUBLIC_CTOR = new MessageCode("BINDING_PROVIDER_FACTORY_NO_PUBLIC_CTOR", "The binding implementation provider factory %1$s must provides a public constructor");
    private static final Name BINDINGS = Name.create(Bindings.class);
    private Map<ElementHandle.Package, JSON> state = new HashMap<ElementHandle.Package, JSON>();

    public BindingMetaModelPlugin() {
        super("binding");
    }

    @Override
    public Set<Class<? extends Annotation>> init(ProcessingContext env) {
        return Collections.singleton(Bindings.class);
    }

    @Override
    public void processAnnotationAdded(ApplicationMetaModel metaModel, AnnotationKey key, AnnotationState added) {
        if (key.getType().equals(BINDINGS)) {
            ProcessingContext env = metaModel.model.processingContext;
            TypeMirror providerFactoryTM = env.getTypeElement(ProviderFactory.class.getName()).asType();
            TypeElement providerElt = env.getTypeElement("javax.inject.Provider");
            DeclaredType providerTM = (DeclaredType)providerElt.asType();
            TypeMirror rawProviderTM = env.erasure(providerTM);
            List bindings = (List)added.get("value");
            ArrayList<JSON> list = new ArrayList<JSON>();
            if (bindings != null) {
                for (Map binding : bindings) {
                    ElementHandle.Class bindingValue = (ElementHandle.Class)binding.get("value");
                    ElementHandle.Class bindingImplementation = (ElementHandle.Class)binding.get("implementation");
                    String scope = (String)binding.get("scope");
                    JSON bindingJSON = new JSON().set("value", bindingValue.getFQN().toString());
                    TypeElement valueElt = env.get(bindingValue);
                    TypeMirror valueTM = valueElt.asType();
                    if (bindingImplementation != null) {
                        TypeElement implementationElt = env.get(bindingImplementation);
                        DeclaredType implementationTM = (DeclaredType)implementationElt.asType();
                        if (implementationElt.getKind() != ElementKind.CLASS) {
                            throw IMPLEMENTATION_INVALID_TYPE.failure((Element)env.get(key.getElement()), providerElt.getQualifiedName());
                        }
                        Set<Modifier> modifiers = implementationElt.getModifiers();
                        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                            throw IMPLEMENTATION_NOT_ABSTRACT.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName());
                        }
                        if (env.isAssignable(implementationTM, providerFactoryTM)) {
                            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                                throw PROVIDER_FACTORY_NOT_PUBLIC.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName());
                            }
                            Element emptyCtor = null;
                            for (ExecutableElement ctorElt : ElementFilter.constructorsIn(env.getAllMembers(implementationElt))) {
                                if (!ctorElt.getParameters().isEmpty()) continue;
                                emptyCtor = ctorElt;
                                break;
                            }
                            if (emptyCtor == null) {
                                throw PROVIDER_FACTORY_NO_ZERO_ARG_CTOR.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName());
                            }
                            if (!emptyCtor.getModifiers().contains((Object)Modifier.PUBLIC)) {
                                throw PROVIDER_FACTORY_NO_PUBLIC_CTOR.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName());
                            }
                        } else if (env.isAssignable(implementationTM, rawProviderTM)) {
                            TypeVariable T = (TypeVariable)providerTM.getTypeArguments().get(0);
                            TypeMirror resolved = env.asMemberOf(implementationTM, T.asElement());
                            if (!env.isAssignable(resolved, valueTM)) {
                                throw PROVIDER_NOT_ASSIGNABLE.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName(), resolved, valueElt.getQualifiedName());
                            }
                        } else if (!env.isAssignable(implementationTM, valueTM)) {
                            throw IMPLEMENTATION_NOT_ASSIGNABLE.failure((Element)env.get(key.getElement()), implementationElt.getQualifiedName(), valueElt.getQualifiedName());
                        }
                        bindingJSON.set("implementation", bindingImplementation.getFQN().toString());
                    } else {
                        if (valueElt.getKind() != ElementKind.CLASS) {
                            throw BEAN_INVALID_TYPE.failure((Element)env.get(key.getElement()), valueElt.getQualifiedName());
                        }
                        Set<Modifier> modifiers = valueElt.getModifiers();
                        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                            throw BEAN_ABSTRACT_TYPE.failure((Element)env.get(key.getElement()), valueElt.getQualifiedName());
                        }
                    }
                    if (scope != null) {
                        bindingJSON.set("scope", scope);
                    }
                    list.add(bindingJSON);
                }
            }
            this.state.put(metaModel.getHandle(), new JSON().set("bindings", list));
        }
    }

    @Override
    public void destroy(ApplicationMetaModel application) {
        this.state.remove(application.getHandle());
    }

    @Override
    public JSON getDescriptor(ApplicationMetaModel application) {
        return this.state.get(application.getHandle());
    }
}

