/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.jar;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import javax.portlet.Portlet;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.jar.JarFileSystem;
import juzu.test.AbstractTestCase;
import org.junit.Test;

public class JarFileSystemTestCase
extends AbstractTestCase {
    @Test
    public void testMissing() throws Exception {
        URL url = Portlet.class.getProtectionDomain().getCodeSource().getLocation();
        JarFile jar = new JarFile(new File(url.toURI()));
        JarFileSystem fs = new JarFileSystem(jar);
        HashSet set = Tools.set((Iterator)fs.getChildren(""));
        HashSet expectedSet = Tools.set((Object[])new String[]{"META-INF/", "javax/"});
        JarFileSystemTestCase.assertEquals((Object)expectedSet, (Object)set);
        HashSet set2 = Tools.set((Iterator)fs.getChildren("META-INF/"));
        HashSet expectedSet2 = Tools.set((Object)"META-INF/MANIFEST.MF");
        JarFileSystemTestCase.assertTrue((boolean)set2.containsAll(expectedSet2));
        HashSet set3 = Tools.set((Iterator)fs.getChildren("javax/"));
        HashSet expectedSet3 = Tools.set((Object)"javax/portlet/");
        JarFileSystemTestCase.assertTrue((boolean)set3.containsAll(expectedSet3));
        JarFileSystemTestCase.assertEquals((String)"javax/", (String)fs.getChild("", "javax"));
        JarFileSystemTestCase.assertEquals((String)"javax/portlet/", (String)fs.getChild("javax/", "portlet"));
        JarFileSystemTestCase.assertEquals((String)"javax/portlet/Portlet.class", (String)fs.getChild("javax/portlet/", "Portlet.class"));
        HashSet set4 = Tools.set((Iterator)fs.getChildren("javax/portlet/filter/"));
        HashSet<String> expectedSet4 = new HashSet<String>();
        expectedSet4.add("javax/portlet/filter/EventFilter.class");
        expectedSet4.add("javax/portlet/filter/PortletRequestWrapper.class");
        expectedSet4.add("javax/portlet/filter/FilterChain.class");
        expectedSet4.add("javax/portlet/filter/ResourceRequestWrapper.class");
        expectedSet4.add("javax/portlet/filter/FilterConfig.class");
        expectedSet4.add("javax/portlet/filter/RenderResponseWrapper.class");
        expectedSet4.add("javax/portlet/filter/PortletResponseWrapper.class");
        expectedSet4.add("javax/portlet/filter/ActionResponseWrapper.class");
        expectedSet4.add("javax/portlet/filter/RenderRequestWrapper.class");
        expectedSet4.add("javax/portlet/filter/ActionFilter.class");
        expectedSet4.add("javax/portlet/filter/RenderFilter.class");
        expectedSet4.add("javax/portlet/filter/EventRequestWrapper.class");
        expectedSet4.add("javax/portlet/filter/ResourceFilter.class");
        expectedSet4.add("javax/portlet/filter/PortletFilter.class");
        expectedSet4.add("javax/portlet/filter/ResourceResponseWrapper.class");
        expectedSet4.add("javax/portlet/filter/ActionRequestWrapper.class");
        expectedSet4.add("javax/portlet/filter/EventResponseWrapper.class");
        JarFileSystemTestCase.assertTrue((boolean)set4.containsAll(expectedSet4));
    }
}

