/*
 * Decompiled with CFR 0.152.
 */
package juzu.test;

import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import juzu.impl.common.Name;
import juzu.impl.common.Tools;
import juzu.impl.fs.Visitor;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import juzu.test.UserAgent;
import juzu.test.protocol.portlet.JuzuPortlet;
import juzu.test.protocol.servlet.JuzuServlet;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Arquillian.class)
public abstract class AbstractWebTestCase
extends AbstractTestCase {
    private static Name applicationName;
    private static boolean asDefault;
    private static CompilerAssert<File, File> compiler;
    private static boolean servlet;
    @ArquillianResource
    protected URL deploymentURL;

    public static Name getApplicationName() {
        return applicationName;
    }

    public static boolean asDefault() {
        return asDefault;
    }

    public static CompilerAssert<File, File> getCompiler() {
        return compiler;
    }

    private static WebArchive createDeployment(boolean servlet, boolean asDefault, boolean incremental, String ... applicationNames) {
        Name[] applicationQNs = new Name[applicationNames.length];
        Name packageQN = null;
        for (int i = 0; i < applicationNames.length; ++i) {
            Name applicationQN;
            applicationQNs[i] = applicationQN = Name.parse((CharSequence)applicationNames[i]);
            packageQN = packageQN == null ? applicationQN : packageQN.getPrefix(applicationQN);
        }
        CompilerAssert<File, File> compiler = AbstractWebTestCase.compiler(incremental, packageQN, new String[0]);
        compiler.assertCompile();
        ReadWriteFileSystem<File> classOutput = compiler.getClassOutput();
        final WebArchive war = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"juzu.war");
        try {
            classOutput.traverse((Visitor)new Visitor.Default<File>(){
                StringBuffer path = new StringBuffer();

                public void enterDir(File dir, String name) throws IOException {
                    if (name.isEmpty()) {
                        this.path.append("classes/");
                    } else {
                        this.path.append(name).append('/');
                    }
                }

                public void leaveDir(File dir, String name) throws IOException {
                    if (name.isEmpty()) {
                        this.path.setLength(0);
                    } else {
                        this.path.setLength(this.path.length() - name.length() - 1);
                    }
                }

                public void file(File file, String name) throws IOException {
                    this.path.append(name);
                    String target = this.path.toString();
                    this.path.setLength(this.path.length() - name.length());
                    war.addAsWebInfResource((Asset)new ByteArrayAsset((InputStream)new FileInputStream(file)), target);
                }
            });
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure(e);
        }
        applicationName = applicationQNs.length > 0 ? applicationQNs[0] : null;
        AbstractWebTestCase.asDefault = asDefault;
        AbstractWebTestCase.compiler = compiler;
        AbstractWebTestCase.servlet = servlet;
        return war;
    }

    public static WebArchive createServletDeployment(String applicationName) {
        return AbstractWebTestCase.createServletDeployment(false, applicationName);
    }

    public static WebArchive createServletDeployment(boolean asDefault, String ... applicationNames) {
        return AbstractWebTestCase.createServletDeployment(false, asDefault, applicationNames);
    }

    public static WebArchive createServletDeployment(boolean incremental, boolean asDefault, String ... applicationNames) {
        String servlet;
        String sourcePath;
        String runModeValue;
        WebArchive war = AbstractWebTestCase.createDeployment(true, asDefault, false, applicationNames);
        try {
            runModeValue = incremental ? "dev" : "prod";
            sourcePath = incremental ? ((File)AbstractWebTestCase.getCompiler().getSourcePath().getRoot()).getCanonicalFile().getAbsolutePath() : "";
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure("Could not read obtain source path", e);
        }
        try {
            servlet = Tools.read((InputStream)JuzuServlet.class.getResourceAsStream("web.xml"));
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure("Could not read portlet xml deployment descriptor", e);
        }
        servlet = String.format(servlet, runModeValue, sourcePath);
        war.setWebXML((Asset)new StringAsset(servlet));
        return war;
    }

    public static WebArchive createPortletDeployment(String packageName) {
        return AbstractWebTestCase.createPortletDeployment(false, packageName);
    }

    public static WebArchive createPortletDeployment(boolean incremental, String packageName) {
        String portlet;
        String sourcePath;
        String runModeValue;
        WebArchive war = AbstractWebTestCase.createDeployment(false, true, incremental, packageName);
        try {
            runModeValue = incremental ? "dev" : "prod";
            sourcePath = incremental ? ((File)AbstractWebTestCase.getCompiler().getSourcePath().getRoot()).getCanonicalFile().getAbsolutePath() : "";
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure("Could not read obtain source path", e);
        }
        try {
            portlet = Tools.read((InputStream)JuzuPortlet.class.getResourceAsStream("portlet.xml"));
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure("Could not read portlet xml deployment descriptor", e);
        }
        portlet = String.format(portlet, "weld", runModeValue, sourcePath);
        war.setWebXML(JuzuPortlet.class.getResource("web.xml"));
        war.addAsWebInfResource((Asset)new StringAsset(portlet), "portlet.xml");
        return war;
    }

    public static WebArchive createPortletDeployment(String packageName, URL portletXML) {
        return AbstractWebTestCase.createPortletDeployment(false, packageName, portletXML);
    }

    public static WebArchive createPortletDeployment(boolean incremental, String packageName, URL portletXML) {
        WebArchive war = AbstractWebTestCase.createDeployment(false, true, incremental, packageName);
        war.setWebXML(JuzuPortlet.class.getResource("web.xml"));
        war.addAsWebInfResource((Asset)new UrlAsset(portletXML), "portlet.xml");
        return war;
    }

    public URL getPortletURL() {
        try {
            return this.deploymentURL.toURI().resolve("embed/JuzuPortlet").toURL();
        }
        catch (Exception e) {
            throw AbstractWebTestCase.failure(e);
        }
    }

    public URL getServletURL() {
        return this.getServletURL("");
    }

    public URL getServletURL(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            URI base = asDefault ? this.deploymentURL.toURI() : this.deploymentURL.toURI().resolve(AbstractWebTestCase.getApplicationName().getIdentifier());
            base = base.resolve(path);
            return base.toURL();
        }
        catch (Exception e) {
            throw AbstractWebTestCase.failure("Could not build application url " + path, e);
        }
    }

    public void assertInternalError() {
        WebClient client = new WebClient();
        try {
            Page page = client.getPage(this.deploymentURL + "/juzu");
            throw AbstractWebTestCase.failure("Was expecting an internal error instead of page " + page.toString());
        }
        catch (FailingHttpStatusCodeException e) {
            AbstractWebTestCase.assertEquals((int)500, (int)e.getStatusCode());
        }
        catch (IOException e) {
            throw AbstractWebTestCase.failure("Was not expecting io exception", e);
        }
    }

    public UserAgent assertInitialPage() {
        return new UserAgent(this.applicationURL());
    }

    public URL applicationURL() {
        if (servlet) {
            return this.getServletURL();
        }
        return this.getPortletURL();
    }

    public URL applicationURL(String path) {
        if (servlet) {
            return this.getServletURL(path);
        }
        throw AbstractWebTestCase.failure("Cannot invoke portlet test with a path: " + path);
    }
}

