/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.classloader;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.inject.Inject;
import juzu.impl.common.Content;
import juzu.impl.common.Timestamped;
import juzu.impl.common.Tools;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.classloader.Node;
import juzu.impl.fs.spi.classloader.URLCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderFileSystem
extends ReadFileSystem<Node> {
    private final URLCache cache;
    private final ClassLoader classLoader;

    public ClassLoaderFileSystem(ClassLoader classLoader) throws IOException {
        URLCache cache = new URLCache();
        cache.add(classLoader);
        cache.add(Inject.class);
        this.cache = cache;
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class<Node> getType() {
        return null;
    }

    @Override
    public String getDescription() {
        return "ClassLoader[]";
    }

    @Override
    public boolean equals(Node left, Node right) {
        return left == right;
    }

    @Override
    public Node getRoot() throws IOException {
        return this.cache.root;
    }

    @Override
    public Node getChild(Node dir, String name) throws IOException {
        return (Node)dir.get(name);
    }

    @Override
    public long getLastModified(Node path) throws IOException {
        return 1L;
    }

    @Override
    public String getName(Node path) throws IOException {
        return (String)path.getKey();
    }

    @Override
    public Iterator<Node> getChildren(Node dir) throws IOException {
        final Iterator entries = dir.getEntries();
        return new Iterator<Node>(){
            private Node next;

            @Override
            public boolean hasNext() {
                while (this.next == null && entries.hasNext()) {
                    Node next = (Node)entries.next();
                    if (next.url == null) continue;
                    this.next = next;
                }
                return this.next != null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Node next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    Node node = this.next;
                    Object var3_2 = null;
                    this.next = null;
                    return node;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.next = null;
                    throw throwable;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public PathType typeOf(Node path) throws IOException {
        return path.url == null ? PathType.DIR : PathType.FILE;
    }

    @Override
    public Timestamped<Content> getContent(Node file) throws IOException {
        if (file.url == null) {
            throw new IOException("Cannot find file " + file.getPath());
        }
        URLConnection conn = file.url.openConnection();
        long lastModified = conn.getLastModified();
        byte[] bytes = Tools.bytes(conn.getInputStream());
        return new Timestamped<Content>(lastModified, new Content(bytes, Charset.defaultCharset()));
    }

    @Override
    public File getFile(Node path) {
        return null;
    }

    @Override
    public URL getURL(Node path) throws NullPointerException, IOException {
        return path.url;
    }
}

