/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Qualifier;
import juzu.Scope;
import juzu.impl.inject.spi.Injector;
import juzu.impl.plugin.application.ApplicationException;
import juzu.inject.ProviderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanDescriptor {
    private final Class<?> declaredType;
    private final Scope scope;
    private final List<Annotation> qualifiers;
    private final Class<?> implementationType;

    public BeanDescriptor(Class<?> declaredType, Scope scope, List<Annotation> qualifiers, Class<?> implementationType) throws NullPointerException, IllegalArgumentException {
        if (declaredType == null) {
            throw new NullPointerException("No null declared type accepted");
        }
        if (qualifiers != null) {
            for (Annotation qualifier : qualifiers) {
                if (qualifier.annotationType().getAnnotation(Qualifier.class) != null) continue;
                throw new IllegalArgumentException("Qualifier annotation " + qualifier + " is not annotated with @Qualifier");
            }
        }
        this.declaredType = declaredType;
        this.scope = scope;
        this.qualifiers = qualifiers;
        this.implementationType = implementationType;
    }

    public Class<?> getDeclaredType() {
        return this.declaredType;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<?> getImplementationType() {
        return this.implementationType;
    }

    public void bind(Injector builder) {
        Class<?> type = this.getDeclaredType();
        Class<?> implementation = this.getImplementationType();
        if (implementation == null) {
            builder.declareBean(type, this.getScope(), this.getQualifiers(), null);
        } else if (ProviderFactory.class.isAssignableFrom(implementation)) {
            Provider<?> provider;
            ProviderFactory mp;
            try {
                mp = (ProviderFactory)implementation.newInstance();
            }
            catch (InstantiationException e) {
                throw new ApplicationException(e);
            }
            catch (IllegalAccessException e) {
                throw new UndeclaredThrowableException(e);
            }
            try {
                provider = mp.getProvider(type);
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            builder.bindProvider(type, this.getScope(), BeanDescriptor.determineQualifiers(this.getQualifiers(), provider.getClass()), provider);
        } else if (Provider.class.isAssignableFrom(implementation)) {
            builder.declareProvider(type, this.getScope(), BeanDescriptor.determineQualifiers(this.getQualifiers(), implementation), implementation);
        } else {
            builder.declareBean(type, this.getScope(), this.getQualifiers(), implementation);
        }
    }

    private static Collection<Annotation> determineQualifiers(Collection<Annotation> qualifiers, Class<?> implementation) {
        ArrayList<Annotation> overridenQualifiers = null;
        try {
            Method get = implementation.getMethod("get", new Class[0]);
            for (Annotation annotation : get.getAnnotations()) {
                if (annotation.annotationType().getAnnotation(Qualifier.class) == null) continue;
                if (overridenQualifiers == null) {
                    overridenQualifiers = new ArrayList<Annotation>();
                }
                overridenQualifiers.add(annotation);
            }
        }
        catch (NoSuchMethodException e) {
            throw new UndeclaredThrowableException(e);
        }
        if (overridenQualifiers != null) {
            qualifiers = overridenQualifiers;
        }
        return qualifiers;
    }
}

