/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.disk;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import juzu.impl.fs.spi.AbstractReadWriteFileSystemTestCase;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.ReadWriteFileSystem;
import juzu.impl.fs.spi.disk.DiskFileSystem;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskFileSystemTestCase
extends AbstractReadWriteFileSystemTestCase<File> {
    @Override
    protected ReadWriteFileSystem<File> create() throws IOException {
        File root = File.createTempFile("juzu", "test");
        DiskFileSystemTestCase.assertTrue((boolean)root.delete());
        DiskFileSystemTestCase.assertTrue((boolean)root.mkdir());
        root.deleteOnExit();
        return new DiskFileSystem(root);
    }

    @Test
    public void testFoo() throws Exception {
        File root = new File(System.getProperty("juzu.test.resources.path"));
        DiskFileSystemTestCase.assertNotNull((Object)root);
        DiskFileSystemTestCase.assertNotNull((Object)root.isDirectory());
        this.doTest((ReadFileSystem)new DiskFileSystem(root, "compiler.disk"), (Object)root);
    }

    private <P> void doTest(ReadFileSystem<P> fs, P root) throws IOException {
        DiskFileSystemTestCase.assertEquals(root, (Object)fs.getRoot());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(root));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(root));
        DiskFileSystemTestCase.assertEquals((String)"", (String)fs.getName(root));
        Iterator rootChildren = fs.getChildren(root);
        DiskFileSystemTestCase.assertTrue((boolean)rootChildren.hasNext());
        Object compiler = rootChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)rootChildren.hasNext());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(compiler));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(compiler));
        DiskFileSystemTestCase.assertEquals((String)"compiler", (String)fs.getName(compiler));
        Iterator compilerChildren = fs.getChildren(compiler);
        DiskFileSystemTestCase.assertTrue((boolean)compilerChildren.hasNext());
        Object disk = compilerChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)compilerChildren.hasNext());
        DiskFileSystemTestCase.assertTrue((boolean)fs.isDir(disk));
        DiskFileSystemTestCase.assertFalse((boolean)fs.isFile(disk));
        DiskFileSystemTestCase.assertEquals((String)"disk", (String)fs.getName(disk));
        Iterator diskChildren = fs.getChildren(disk);
        DiskFileSystemTestCase.assertTrue((boolean)diskChildren.hasNext());
        Object a = diskChildren.next();
        DiskFileSystemTestCase.assertFalse((boolean)diskChildren.hasNext());
        DiskFileSystemTestCase.assertFalse((boolean)fs.isDir(a));
        DiskFileSystemTestCase.assertTrue((boolean)fs.isFile(a));
        DiskFileSystemTestCase.assertEquals((String)"A.java", (String)fs.getName(a));
    }
}

