/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import juzu.impl.router.PathParam;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.impl.router.Router;
import juzu.impl.router.RouterConfigException;
import juzu.impl.router.regex.REFactory;
import juzu.test.AbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouterAssert
extends Router {
    public RouterAssert() throws RouterConfigException {
    }

    public RouterAssert(char separatorEscape) throws RouterConfigException {
        super(separatorEscape);
    }

    public RouterAssert(char separatorEscape, REFactory regexFactory) throws RouterConfigException {
        super(separatorEscape, regexFactory);
    }

    private ArrayList<Map<String, String>> foo(String path, Map<String, String> parameters) {
        HashMap<String, String[]> tmp = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            tmp.put(entry.getKey(), new String[]{entry.getValue()});
        }
        Iterator result = this.matcher(path, tmp);
        ArrayList<Map<String, String>> a = new ArrayList<Map<String, String>>();
        while (result.hasNext()) {
            HashMap actual = new HashMap();
            for (Map.Entry entry : ((RouteMatch)result.next()).getMatched().entrySet()) {
                actual.put(((PathParam)entry.getKey()).getName(), entry.getValue());
            }
            a.add(actual);
        }
        return a;
    }

    public void assertRoute(Map<String, String> expected, String path, Map<String, String> parameters) {
        ArrayList<Map<String, String>> b = this.foo(path, parameters);
        if (b.isEmpty()) {
            throw AbstractTestCase.failure("Was expecting at least one result for " + path + " " + parameters);
        }
        Assert.assertFalse((boolean)b.isEmpty());
        AbstractTestCase.assertEquals(Collections.singletonList(expected), b.subList(0, 1));
    }

    public Map<String, String> assertRoute(Route expectedRoute, String path) {
        return this.assertRoute(expectedRoute, path, Collections.<String, String>emptyMap());
    }

    public void assertRoute(Route expectedRoute, Map<String, String> expectedParameters, String path) {
        Map<String, String> parameters = this.assertRoute(expectedRoute, path, Collections.<String, String>emptyMap());
        Assert.assertEquals(expectedParameters, parameters);
    }

    public Map<String, String> assertRoute(Route expectedRoute, String path, Map<String, String> parameters) {
        HashMap<String, String[]> tmp = new HashMap<String, String[]>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            tmp.put(entry.getKey(), new String[]{entry.getValue()});
        }
        Iterator result = this.matcher(path, tmp);
        Assert.assertTrue((boolean)result.hasNext());
        RouteMatch match = (RouteMatch)result.next();
        Assert.assertSame((Object)expectedRoute, (Object)match.getRoute());
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry entry : match.getMatched().entrySet()) {
            ret.put(((PathParam)entry.getKey()).getName(), (String)entry.getValue());
        }
        return ret;
    }

    public void assertRoutes(Iterable<Route> expected, String path) {
        Iterator matches = this.matcher(path, Collections.emptyMap());
        ArrayList<Route> routes = new ArrayList<Route>();
        while (matches.hasNext()) {
            routes.add(((RouteMatch)matches.next()).getRoute());
        }
        AbstractTestCase.assertEquals(expected, routes);
    }

    public void assertRoute(Map<String, String> expected, String path) {
        this.assertRoute(expected, path, Collections.<String, String>emptyMap());
    }

    public void assertRoutes(List<Map<String, String>> expected, String path, Map<String, String> parameters) {
        AbstractTestCase.assertEquals(expected, this.foo(path, parameters));
    }

    public void assertRoutes(List<Map<String, String>> expected, String path) {
        AbstractTestCase.assertEquals(expected, this.foo(path, Collections.<String, String>emptyMap()));
    }
}

