/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.Arrays;
import juzu.impl.inject.spi.InjectorProvider;
import juzu.test.AbstractInjectTestCase;
import juzu.test.protocol.mock.MockActionBridge;
import juzu.test.protocol.mock.MockApplication;
import juzu.test.protocol.mock.MockClient;
import juzu.test.protocol.mock.MockRenderBridge;
import org.junit.Test;

public class MethodParametersTestCase
extends AbstractInjectTestCase {
    public static boolean WAS_NULL;

    public MethodParametersTestCase(InjectorProvider di) {
        super(di);
    }

    @Test
    public void testStringArray() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.method.parameters.string.array").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render("none");
        MockRenderBridge mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("0");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("1");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar").toString(), (String)mv.assertStringResult());
        render = client.render("2");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar_1", "bar_2").toString(), (String)mv.assertStringResult());
    }

    @Test
    public void testStringList() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.method.parameters.string.list").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render("none");
        MockRenderBridge mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("0");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)"", (String)mv.assertStringResult());
        render = client.render("1");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar").toString(), (String)mv.assertStringResult());
        render = client.render("2");
        mv = (MockRenderBridge)client.invoke(render.assertStringResult());
        MethodParametersTestCase.assertEquals((String)Arrays.asList("bar_1", "bar_2").toString(), (String)mv.assertStringResult());
    }

    @Test
    public void testBean() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.method.parameters.bean").init();
        MockClient client = app.client();
        this.assertBean(client, "a", "v");
        this.assertBean(client, "b", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "c", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "d", "v");
        this.assertBean(client, "e", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "f", Arrays.asList("v1", "v2").toString());
        this.assertBean(client, "g", "s_valuev");
        this.assertBean(client, "g", "s_valuev");
        this.assertBean(client, "h", "s_valuev");
    }

    private void assertBean(MockClient client, String name, Object expected) throws Exception {
        MockRenderBridge render = client.render(name);
        String url = render.assertStringResult();
        MockRenderBridge m = (MockRenderBridge)client.invoke(url);
        MethodParametersTestCase.assertEquals((Object)expected, (Object)m.assertStringResult());
        render = client.render(name + "Action");
        url = render.assertStringResult();
        MockActionBridge action = (MockActionBridge)client.invoke(url);
        MockRenderBridge m2 = (MockRenderBridge)client.invoke(action.assertUpdate());
        MethodParametersTestCase.assertEquals((Object)expected, (Object)m2.assertStringResult());
    }

    @Test
    public void testUnresolvedContext() throws Exception {
        MockApplication<File> app = this.application("plugin.controller.method.parameters.context.unresolved").init();
        MockClient client = app.client();
        MockRenderBridge render = client.render("index");
        MethodParametersTestCase.assertTrue((boolean)WAS_NULL);
    }
}

