/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.controller;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import juzu.impl.common.Cardinality;
import juzu.impl.plugin.application.descriptor.ApplicationDescriptor;
import juzu.impl.request.Method;
import juzu.impl.request.PhaseParameter;
import juzu.request.Phase;
import juzu.test.AbstractTestCase;
import juzu.test.CompilerAssert;
import org.junit.Test;

public class ResourceMethodTestCase
extends AbstractTestCase {
    private Class<?> aClass;
    private ApplicationDescriptor descriptor;

    public void setUp() throws Exception {
        CompilerAssert<File, File> compiler = this.compiler("plugin.controller.method.resource");
        compiler.assertCompile();
        this.aClass = compiler.assertClass("plugin.controller.method.resource.A");
        compiler.assertClass("plugin.controller.method.resource.A_");
        Class<?> appClass = compiler.assertClass("plugin.controller.method.resource.Application");
        this.descriptor = ApplicationDescriptor.create(appClass);
    }

    @Test
    public void testNoArg() throws Exception {
        Method cm = this.descriptor.getControllers().getMethod(this.aClass, "noArg", new Class[0]);
        ResourceMethodTestCase.assertEquals((String)"noArg", (String)cm.getName());
        ResourceMethodTestCase.assertEquals((Object)Phase.RESOURCE, (Object)cm.getPhase());
        ResourceMethodTestCase.assertEquals(Collections.emptyList(), cm.getParameters());
    }

    @Test
    public void testStringArg() throws Exception {
        Method cm = this.descriptor.getControllers().getMethod(this.aClass, "oneArg", new Class[]{String.class});
        ResourceMethodTestCase.assertEquals((String)"oneArg", (String)cm.getName());
        ResourceMethodTestCase.assertEquals((Object)Phase.RESOURCE, (Object)cm.getPhase());
        ResourceMethodTestCase.assertEquals(Arrays.asList(new PhaseParameter("foo", null, Cardinality.SINGLE)), cm.getParameters());
    }
}

