/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.web;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import juzu.PropertyMap;
import juzu.PropertyType;
import juzu.Response;
import juzu.impl.asset.Asset;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.DispatchSPI;
import juzu.impl.bridge.spi.RequestBridge;
import juzu.impl.bridge.spi.web.Handler;
import juzu.impl.bridge.spi.web.WebBridge;
import juzu.impl.common.MethodHandle;
import juzu.impl.common.MimeType;
import juzu.impl.common.Tools;
import juzu.impl.common.URIWriter;
import juzu.impl.inject.Scoped;
import juzu.impl.inject.ScopedContext;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.Argument;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.router.Route;
import juzu.impl.router.RouteMatch;
import juzu.request.ApplicationContext;
import juzu.request.HttpContext;
import juzu.request.Phase;
import juzu.request.SecurityContext;
import juzu.request.UserContext;
import juzu.request.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebRequestBridge
implements RequestBridge,
WindowContext {
    final Bridge bridge;
    final Handler handler;
    final WebBridge http;
    final Map<String, String[]> parameters;
    final Method<?> target;
    final Map<String, ? extends Argument> arguments;
    protected Request request;
    protected UserContext userContext;
    protected Response response;

    WebRequestBridge(Bridge bridge, Handler handler, WebBridge http, Method<?> target, Map<String, String[]> parameters) {
        this.arguments = target.getArguments(parameters);
        this.bridge = bridge;
        this.target = target;
        this.handler = handler;
        this.http = http;
        this.parameters = parameters;
        this.request = null;
    }

    @Override
    public MethodHandle getTarget() {
        return this.target.getHandle();
    }

    @Override
    public Map<String, ? extends Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public <T> T getProperty(PropertyType<T> propertyType) {
        if (PropertyType.PATH.equals(propertyType)) {
            return propertyType.cast(this.http.getRequestURI());
        }
        return null;
    }

    @Override
    public final String getNamespace() {
        return "window_ns";
    }

    @Override
    public final String getId() {
        return "window_id";
    }

    @Override
    public final Map<String, String[]> getParameters() {
        return this.parameters;
    }

    @Override
    public final HttpContext getHttpContext() {
        return this.http.getHttpContext();
    }

    @Override
    public final WindowContext getWindowContext() {
        return this;
    }

    @Override
    public final SecurityContext getSecurityContext() {
        return null;
    }

    @Override
    public UserContext getUserContext() {
        return this.http.getUserContext();
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return null;
    }

    @Override
    public final Scoped getRequestValue(Object key) {
        ScopedContext context = this.http.getRequestScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setRequestValue(Object key, Scoped value) {
        if (value != null) {
            ScopedContext context = this.http.getRequestScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getRequestScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getFlashValue(Object key) {
        ScopedContext context = this.http.getFlashScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setFlashValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.http.getFlashScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getFlashScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getSessionValue(Object key) {
        ScopedContext context = this.http.getSessionScope(false);
        return context != null ? context.get(key) : null;
    }

    @Override
    public final void setSessionValue(Object key, Scoped value) {
        if (value == null) {
            ScopedContext context = this.http.getSessionScope(false);
            if (context != null) {
                context.set(key, null);
            }
        } else {
            this.http.getSessionScope(true).set(key, value);
        }
    }

    @Override
    public final Scoped getIdentityValue(Object key) {
        return null;
    }

    @Override
    public final void setIdentityValue(Object key, Scoped value) {
    }

    @Override
    public void purgeSession() {
        this.http.purgeSession();
    }

    @Override
    public final DispatchSPI createDispatch(Phase phase, final MethodHandle target, final Map<String, String[]> parameters) {
        Method method = this.bridge.application.getPlugin(ControllerPlugin.class).getDescriptor().getMethodByHandle(target);
        Route route = this.handler.getRoute(method.getHandle());
        if (route == null && this.bridge.application.getPlugin(ControllerPlugin.class).getResolver().isIndex(method)) {
            route = this.handler.getRoot();
        }
        if (route != null) {
            Map<String, String> params;
            if (parameters.isEmpty()) {
                params = Collections.emptyMap();
            } else {
                params = new HashMap<String, String>(parameters.size());
                for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                    params.put(entry.getKey(), entry.getValue()[0]);
                }
            }
            final RouteMatch match = route.matches(params);
            if (match != null) {
                return new DispatchSPI(){

                    @Override
                    public MethodHandle getTarget() {
                        return target;
                    }

                    @Override
                    public Map<String, String[]> getParameters() {
                        return parameters;
                    }

                    @Override
                    public <T> String checkPropertyValidity(PropertyType<T> propertyType, T propertyValue) {
                        return null;
                    }

                    @Override
                    public void renderURL(PropertyMap properties, MimeType mimeType, Appendable appendable) throws IOException {
                        WebRequestBridge.this.http.renderRequestURL(appendable);
                        URIWriter writer = new URIWriter(appendable, mimeType);
                        match.render(writer);
                        for (Map.Entry<String, String> entry : match.getUnmatched().entrySet()) {
                            String[] values;
                            for (String value : values = (String[])parameters.get(entry.getKey())) {
                                writer.appendQueryParameter(entry.getKey(), value);
                            }
                        }
                    }
                };
            }
            StringBuilder msg = new StringBuilder("The parameters ");
            Tools.toString(parameters.entrySet(), msg);
            msg.append(" are not valid");
            throw new IllegalArgumentException(msg.toString());
        }
        throw new UnsupportedOperationException("handle me gracefully method not mapped " + method.getHandle());
    }

    @Override
    public void setResponse(Response response) throws IllegalArgumentException, IOException {
        this.response = response;
    }

    @Override
    public final void begin(Request request) {
        this.request = request;
    }

    @Override
    public void end() {
        this.request = null;
        ScopedContext context = this.http.getRequestScope(false);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invoke() throws Exception {
        try {
            this.bridge.application.getPlugin(ControllerPlugin.class).invoke(this);
        }
        finally {
            Tools.safeClose(this);
        }
    }

    boolean send() throws IOException {
        if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            this.http.send(error, this.bridge.module.context.getRunMode().getPrettyFail());
            return true;
        }
        return false;
    }

    private String getAssetURL(Asset asset) throws IOException {
        StringBuilder url = new StringBuilder();
        String uri = asset.getURI();
        this.http.renderAssetURL(asset.getLocation(), uri, url);
        return url.toString();
    }
}

