/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import juzu.impl.common.AbstractParameterParser;
import juzu.impl.common.PercentCodec;

public class FormURLEncodedParser
extends AbstractParameterParser {
    private final Charset encoding;

    public FormURLEncodedParser(Charset encoding, CharSequence s, int from, int to) {
        super(s, from, to);
        this.encoding = encoding;
    }

    protected String safeDecodeName(String s) {
        return this.safeDecodeValue(s);
    }

    protected String safeDecodeValue(String s) {
        int len = s.length();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(20);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            if (c == '%') {
                if (i + 2 < len) {
                    int i1 = PercentCodec.hex(s.charAt(i + 1));
                    int i2 = PercentCodec.hex(s.charAt(i + 2));
                    int b = i1 * 16 + i2;
                    baos.write(b);
                    i += 3;
                    continue;
                }
                return null;
            }
            if (c == '+') {
                c = ' ';
            }
            if (baos.size() > 0) {
                sb.append(new String(baos.toByteArray(), this.encoding));
                baos.reset();
            }
            sb.append(c);
            ++i;
        }
        if (baos.size() > 0) {
            sb.append(new String(baos.toByteArray(), this.encoding));
            baos.reset();
        }
        return sb.toString();
    }
}

