/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.bridge.spi.portlet;

import java.io.IOException;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import juzu.EventQueue;
import juzu.Response;
import juzu.bridge.portlet.JuzuPortlet;
import juzu.impl.bridge.Bridge;
import juzu.impl.bridge.spi.portlet.PortletEventProducer;
import juzu.impl.bridge.spi.portlet.PortletRequestBridge;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.ContextualParameter;
import juzu.impl.request.ControlParameter;
import juzu.impl.request.Method;
import juzu.request.Phase;
import juzu.request.ResponseParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletInteractionBridge<Rq extends PortletRequest, Rs extends StateAwareResponse>
extends PortletRequestBridge<Rq, Rs> {
    protected PortletInteractionBridge(Bridge bridge, Rq req, Rs resp, PortletConfig config) {
        super(bridge, req, resp, config);
        this.init();
    }

    protected PortletInteractionBridge(Bridge bridge, Rq req, Rs resp, PortletConfig config, Method<?> target, Map<String, String[]> parameters) {
        super(bridge, req, resp, config, target, parameters);
        this.init();
    }

    private void init() {
        for (ControlParameter parameter : this.target.getParameters()) {
            ContextualParameter contextualParameter;
            if (!(parameter instanceof ContextualParameter) || !EventQueue.class.isAssignableFrom((contextualParameter = (ContextualParameter)parameter).getType())) continue;
            PortletEventProducer producer = new PortletEventProducer();
            this.arguments.put(contextualParameter, producer);
        }
    }

    @Override
    public void send() throws IOException, PortletException {
        if (this.response instanceof Response.View) {
            WindowState windowState;
            Phase.View.Dispatch update = (Phase.View.Dispatch)this.response;
            Map<String, ResponseParameter> parameters = update.getParameters();
            for (ResponseParameter entry : parameters.values()) {
                ((StateAwareResponse)this.resp).setRenderParameter(entry.getName(), entry.toArray());
            }
            Method method = this.bridge.application.getPlugin(ControllerPlugin.class).getDescriptor().getMethodByHandle(update.getTarget());
            ((StateAwareResponse)this.resp).setRenderParameter("juzu.op", method.getId());
            PortletMode portletMode = update.getProperties().getValue(JuzuPortlet.PORTLET_MODE);
            if (portletMode != null) {
                try {
                    ((StateAwareResponse)this.resp).setPortletMode(portletMode);
                }
                catch (PortletModeException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if ((windowState = update.getProperties().getValue(JuzuPortlet.WINDOW_STATE)) != null) {
                try {
                    ((StateAwareResponse)this.resp).setWindowState(windowState);
                }
                catch (WindowStateException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (this.response instanceof Response.Error) {
            Response.Error error = (Response.Error)this.response;
            throw new PortletException(error.getCause());
        }
    }
}

