/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.xml.bind.DatatypeConverter;
import juzu.impl.bridge.Parameters;
import juzu.io.UndeclaredIOException;
import juzu.request.ResponseParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO_8859_2 = Charset.forName("ISO-8859-2");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };
    public static final Comparator<Completion> COMPLETION_COMPARATOR = new Comparator<Completion>(){

        @Override
        public int compare(Completion o1, Completion o2) {
            return o1.getValue().compareTo(o2.getValue());
        }
    };
    private static final Iterable EMPTY_ITERABLE = new Iterable(){

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }
    };
    public static Pattern EMPTY_NO_RECURSE = Pattern.compile("");
    public static Pattern EMPTY_RECURSE = Pattern.compile(".*");

    public static Pattern getPackageMatcher(String packageName, boolean recurse) {
        if (packageName.length() == 0) {
            return recurse ? EMPTY_RECURSE : EMPTY_NO_RECURSE;
        }
        String regex = recurse ? Pattern.quote(packageName) + "(\\..*)?" : Pattern.quote(packageName);
        return Pattern.compile(regex);
    }

    public static String parentPackageOf(String pkgName) {
        int index = pkgName.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return pkgName.substring(0, index);
    }

    public static void escape(CharSequence s, StringBuilder appendable) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\n') {
                appendable.append("\\n");
                continue;
            }
            if (c == '\'') {
                appendable.append("\\'");
                continue;
            }
            if (c == '\r') continue;
            appendable.append(c);
        }
    }

    public static boolean safeEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o2 != null && o1.equals(o2);
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Method safeGetMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        try {
            return type.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static <E> void addAll(Collection<? super E> collection, Iterable<E> elements) {
        for (E element : elements) {
            collection.add(element);
        }
    }

    public static <T> List<T> safeUnmodifiableList(T ... list) {
        return Tools.safeUnmodifiableList(Arrays.asList(list));
    }

    public static <T> List<T> safeUnmodifiableList(List<T> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bytes(InputStream in) throws IOException {
        byte[] byArray;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(in.available());
            Tools.copy(in, baos);
            byArray = baos.toByteArray();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return byArray;
    }

    public static void write(String content, File f) throws IOException {
        Tools.write(content.getBytes(), f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(byte[] content, File f) throws IOException {
        FileOutputStream out = new FileOutputStream(f);
        try {
            Tools.copy(new ByteArrayInputStream(content), out);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
    }

    public static Map<String, String> responseHeaders(HttpURLConnection conn) {
        Map<String, String> headers = Collections.emptyMap();
        int i = 0;
        while (true) {
            String name = conn.getHeaderFieldKey(i);
            String value = conn.getHeaderField(i);
            if (name == null && value == null) break;
            if (name != null) {
                if (headers.isEmpty()) {
                    headers = new HashMap<String, String>();
                }
                headers.put(name, value);
            }
            ++i;
        }
        return headers;
    }

    public static String read(URL url) throws IOException {
        return Tools.read(url.openStream());
    }

    public static String read(File f) throws IOException {
        return Tools.read(new FileInputStream(f));
    }

    public static String read(InputStream in) throws IOException {
        return Tools.read(in, UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(InputStream in, Charset charset) throws IOException {
        String string;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Tools.copy(in, baos);
            string = new String(baos.toByteArray(), charset);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return string;
    }

    public static <O extends OutputStream> O copy(InputStream in, O out) throws IOException {
        int l;
        byte[] buffer = new byte[256];
        while ((l = in.read(buffer)) != -1) {
            out.write(buffer, 0, l);
        }
        return out;
    }

    public static String unquote(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("Can't unquote null string");
        }
        if (s.length() > 1) {
            char c1 = s.charAt(0);
            char c2 = s.charAt(s.length() - 1);
            if ((c1 == '\'' || c1 == '\"') && c1 == c2) {
                return s.substring(1, s.length() - 1);
            }
        }
        return s;
    }

    public static String join(char separator, String ... names) {
        return Tools.join(separator, names, 0, names.length);
    }

    public static String join(char separator, String[] names, int from, int end) {
        int length = 0;
        for (int i = from; i < end; ++i) {
            if (i > from) {
                ++length;
            }
            length += names[i].length();
        }
        return Tools.join(new StringBuilder(length), separator, names, from, end).toString();
    }

    public static String join(char separator, Iterator<String> names) {
        return Tools.join(new StringBuilder(), separator, names).toString();
    }

    public static String join(char separator, Iterable<String> names) {
        return Tools.join(separator, names.iterator());
    }

    public static StringBuilder join(StringBuilder sb, char separator, String ... names) {
        return Tools.join(sb, separator, names, 0, names.length);
    }

    public static StringBuilder join(StringBuilder sb, char separator, String[] names, int from, int end) {
        try {
            Tools.join(sb, separator, names, from, end);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static StringBuilder join(StringBuilder sb, char separator, Iterator<String> names) {
        try {
            Tools.join(sb, separator, names);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static StringBuilder join(StringBuilder sb, char separator, Iterable<String> names) {
        try {
            Tools.join(sb, separator, names);
            return sb;
        }
        catch (IOException e) {
            throw new UndeclaredIOException(e);
        }
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, String ... names) throws IOException {
        return Tools.join(appendable, separator, names, 0, names.length);
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, String[] names, int from, int end) throws IOException {
        int length = end - from;
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                appendable.append(names[from]);
                break;
            }
            default: {
                for (int i = from; i < end; ++i) {
                    if (i > from) {
                        appendable.append(separator);
                    }
                    appendable.append(names[i]);
                }
            }
        }
        return appendable;
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, Iterable<String> names) throws IOException {
        return Tools.join(appendable, separator, names.iterator());
    }

    public static <A extends Appendable> Appendable join(A appendable, char separator, Iterator<String> names) throws IOException {
        if (names.hasNext()) {
            appendable.append(names.next());
            while (names.hasNext()) {
                appendable.append(separator);
                appendable.append(names.next());
            }
        }
        return appendable;
    }

    public static <A extends Appendable> A nameOf(Class<?> clazz, A appendable) throws IOException {
        if (clazz.isMemberClass()) {
            Tools.nameOf(clazz.getEnclosingClass(), appendable).append('.').append(clazz.getSimpleName());
        } else {
            appendable.append(clazz.getSimpleName());
        }
        return appendable;
    }

    public static String getName(Class<?> clazz) {
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Cannot use local or anonymous class");
        }
        try {
            return Tools.nameOf(clazz, new StringBuilder()).toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String getImport(Class<?> clazz) {
        if (clazz.isLocalClass() || clazz.isAnonymousClass()) {
            throw new IllegalArgumentException("Cannot use local or anonymous class");
        }
        if (clazz.isMemberClass()) {
            StringBuilder sb = new StringBuilder();
            while (clazz.isMemberClass()) {
                sb.insert(0, clazz.getSimpleName());
                sb.insert(0, '.');
                clazz = clazz.getEnclosingClass();
            }
            sb.insert(0, clazz.getSimpleName());
            String pkg = clazz.getPackage().getName();
            if (pkg.length() > 0) {
                sb.insert(0, '.');
                sb.insert(0, pkg);
            }
            return sb.toString();
        }
        return clazz.getName();
    }

    public static <E> HashSet<E> addToHashSet(Set<E> set, E e) {
        HashSet<E> hashSet = set instanceof HashSet ? (HashSet<E>)set : new HashSet<E>(set);
        hashSet.add(e);
        return hashSet;
    }

    public static <E> ArrayList<E> addToArrayList(List<E> list, E e) {
        ArrayList<E> arrayList = list instanceof ArrayList ? (ArrayList<E>)list : new ArrayList<E>(list);
        arrayList.add(e);
        return arrayList;
    }

    public static <E> HashSet<E> set() {
        return new HashSet();
    }

    public static <E> HashSet<E> set(E element) {
        HashSet<E> set = new HashSet<E>();
        set.add(element);
        return set;
    }

    public static <E> HashSet<E> set(E ... elements) {
        HashSet set = new HashSet(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> HashSet<E> set(Iterable<E> elements) {
        return Tools.set(elements.iterator());
    }

    public static <E> HashSet<E> set(Iterator<E> elements) {
        HashSet<E> list = new HashSet<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> HashSet<E> set(Enumeration<E> elements) {
        HashSet<E> list = new HashSet<E>();
        while (elements.hasMoreElements()) {
            list.add(elements.nextElement());
        }
        return list;
    }

    public static <E> ArrayList<E> list(Iterable<E> elements) {
        return Tools.list(elements.iterator());
    }

    public static <E> ArrayList<E> list(Iterator<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasNext()) {
            list.add(elements.next());
        }
        return list;
    }

    public static <E> ArrayList<E> list(Enumeration<E> elements) {
        ArrayList<E> list = new ArrayList<E>();
        while (elements.hasMoreElements()) {
            list.add(elements.nextElement());
        }
        return list;
    }

    public static <E> ArrayList<E> list(E ... elements) {
        ArrayList set = new ArrayList(elements.length);
        Collections.addAll(set, elements);
        return set;
    }

    public static <E> Iterable<E> iterable(final Enumeration<E> elements) throws NullPointerException {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Tools.iterator(elements);
            }
        };
    }

    public static <E> Iterator<E> iterator(final Enumeration<E> elements) throws NullPointerException {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return elements.hasMoreElements();
            }

            @Override
            public E next() {
                return elements.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Read only");
            }
        };
    }

    public static <E> Iterable<E> iterable(final E element) throws NullPointerException {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return Tools.iterator(element);
            }
        };
    }

    public static <E> Iterator<E> iterator(final E element) throws NullPointerException {
        return new Iterator<E>(){
            boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return element;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> Iterable<E> iterable(E ... elements) throws NullPointerException {
        return new IterableArray<E>(elements, 0, elements.length);
    }

    public static <E> Iterator<E> iterator(E ... elements) throws NullPointerException {
        return new ArrayIterator<E>(elements, elements.length, 0);
    }

    public static <E> IterableArray<E> iterable(E[] elements, int from, int to) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
        return new IterableArray<E>(elements, from, to);
    }

    public static <E> Iterator<E> iterator(int from, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new ArrayIterator<E>(elements, elements.length, from);
    }

    public static <E> Iterable<E> iterable(int from, int to, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new IterableArray<E>(elements, from, to);
    }

    public static <E> Iterator<E> iterator(int from, int to, E ... elements) throws NullPointerException, IndexOutOfBoundsException {
        return new ArrayIterator<E>(elements, to, from);
    }

    public static <E> Iterator<E> emptyIterator() {
        Iterator iterator = EMPTY_ITERATOR;
        return iterator;
    }

    public static <E> Iterable<E> emptyIterable() {
        Iterable iterable = EMPTY_ITERABLE;
        return iterable;
    }

    public static <E> Iterator<E> append(final Iterator<E> iterator, final E ... elements) {
        return new Iterator<E>(){
            int index = -1;

            @Override
            public boolean hasNext() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return true;
                    }
                    this.index = 0;
                }
                return this.index < elements.length;
            }

            @Override
            public E next() {
                if (this.index == -1) {
                    if (iterator.hasNext()) {
                        return iterator.next();
                    }
                    this.index = 0;
                }
                if (this.index < elements.length) {
                    return elements[this.index++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <E> E[] appendTo(E[] array, E o) throws IllegalArgumentException, ClassCastException {
        if (array == null) {
            throw new IllegalArgumentException();
        }
        Class<?> componentType = array.getClass().getComponentType();
        if (o != null && !componentType.isAssignableFrom(o.getClass())) {
            throw new ClassCastException("Object with class " + o.getClass().getName() + " cannot be casted to class " + componentType.getName());
        }
        Object[] copy = (Object[])Array.newInstance(componentType, array.length + 1);
        System.arraycopy(array, 0, copy, 0, array.length);
        copy[array.length] = o;
        return copy;
    }

    public static <S extends Serializable> S unserialize(Class<S> expectedType, File f) throws IOException, ClassNotFoundException {
        return (S)((Serializable)Tools.unserialize(expectedType, new FileInputStream(f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <S> S unserialize(Class<S> expectedType, InputStream in) throws IOException, ClassNotFoundException {
        S s;
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            Object o = ois.readObject();
            s = expectedType.cast(o);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            Tools.safeClose(in);
            throw throwable;
        }
        Tools.safeClose(in);
        return s;
    }

    public static <S extends Serializable> void serialize(S value, File f) throws IOException {
        Tools.serialize(value, new FileOutputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Serializable> void serialize(T value, OutputStream out) throws IOException {
        ObjectOutputStream ois = new ObjectOutputStream(out);
        try {
            ois.writeObject(value);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Tools.safeClose(out);
            throw throwable;
        }
        Tools.safeClose(out);
    }

    public static <T extends Serializable> T clone(T value) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Tools.serialize(value, baos);
        byte[] bytes = baos.toByteArray();
        return (T)((Serializable)Tools.unserialize(Object.class, new ByteArrayInputStream(bytes)));
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static long parseISO8601(String date) {
        return DatatypeConverter.parseDateTime((String)date).getTimeInMillis();
    }

    public static String formatISO8601(long timeMillis) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(timeMillis);
        return DatatypeConverter.printDateTime((Calendar)c);
    }

    public static long handle(Element te) {
        long hash = 0L;
        for (Element element : te.getEnclosedElements()) {
            hash = 31L * hash + Tools.handle(element);
        }
        hash = 31L * hash + (long)te.getSimpleName().toString().hashCode();
        return hash;
    }

    public static int indexOf(CharSequence s, char c, int from) {
        return Tools.indexOf(s, c, from, s.length());
    }

    public static int indexOf(CharSequence s, char c, int from, int end) {
        if (from < end) {
            if (from < 0) {
                from = 0;
            }
            while (from < end) {
                if (s.charAt(from) == c) {
                    return from;
                }
                ++from;
            }
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence s, char c) {
        return Tools.lastIndexOf(s, c, s.length() - 1);
    }

    public static int lastIndexOf(CharSequence s, char c, int from) {
        for (from = Math.min(from, s.length() - 1); from >= 0; --from) {
            if (s.charAt(from) != c) continue;
            return from;
        }
        return -1;
    }

    public static int count(String s, String separator) {
        int pos;
        if (separator.length() == 0) {
            return s.length() + 1;
        }
        int count = 0;
        int prev = 0;
        while ((pos = s.indexOf(separator, prev)) != -1) {
            ++count;
            prev = pos + separator.length();
        }
        return count;
    }

    public static String[] split(CharSequence s, char separator) {
        return Tools.foo(s, separator, 0, 0, 0);
    }

    public static String[] split(CharSequence s, char separator, int rightPadding) {
        if (rightPadding < 0) {
            throw new IllegalArgumentException("Right padding cannot be negative");
        }
        return Tools.foo(s, separator, 0, 0, rightPadding);
    }

    private static String[] foo(CharSequence s, char separator, int count, int from, int rightPadding) {
        int len = s.length();
        if (from < len) {
            String[] ret;
            int to;
            for (to = from; to < len && s.charAt(to) != separator; ++to) {
            }
            if (to == len - 1) {
                ret = new String[count + 2 + rightPadding];
                ret[count + 1] = "";
            } else {
                ret = to == len ? new String[count + 1 + rightPadding] : Tools.foo(s, separator, count + 1, to + 1, rightPadding);
            }
            ret[count] = from == to ? "" : s.subSequence(from, to).toString();
            return ret;
        }
        if (from == len) {
            return new String[count + rightPadding];
        }
        throw new AssertionError();
    }

    public static AnnotationMirror getAnnotation(Element element, String annotationFQN) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().toString().equals(annotationFQN)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static StringBuilder toString(Iterable<Map.Entry<String, String[]>> entries, StringBuilder sb) {
        sb.append('{');
        Iterator<Map.Entry<String, String[]>> i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry<String, String[]> entry = i.next();
            sb.append(entry.getKey()).append("=[");
            String[] value = entry.getValue();
            for (int j = 0; j < value.length; ++j) {
                if (j > 0) {
                    sb.append(',');
                }
                sb.append(value[j]);
            }
            sb.append(']');
            if (!i.hasNext()) continue;
            sb.append(',');
        }
        sb.append('}');
        return sb;
    }

    public static String nextUUID() {
        return UUID.randomUUID().toString();
    }

    public static HashMap<String, String[]> toHashMap(Parameters parameters) {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (ResponseParameter parameter : parameters.values()) {
            map.put(parameter.getName(), parameter.toArray());
        }
        return map;
    }

    public static BigInteger bitSet(CharSequence s) {
        BigInteger current = BigInteger.ZERO;
        for (int i = s.length() - 1; i >= 0; --i) {
            char c = s.charAt(i);
            current = current.setBit(c);
        }
        return current;
    }

    public static BigInteger bitSet(char ... chars) {
        BigInteger current = BigInteger.ZERO;
        for (char c : chars) {
            current = current.setBit(c);
        }
        return current;
    }

    public static String[] safeConcat(String[] first, String[] second) {
        if (first != null) {
            if (second != null) {
                String[] concat = new String[first.length + second.length];
                System.arraycopy(first, 0, concat, 0, first.length);
                System.arraycopy(second, 0, concat, first.length, second.length);
                return concat;
            }
            return first;
        }
        if (second != null) {
            return second;
        }
        return EMPTY_STRING_ARRAY;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IterableArray<E>
    implements Iterable<E> {
        private final E[] elements;
        private final int from;
        private final int to;

        IterableArray(E[] elements, int from, int to) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
            if (elements == null) {
                throw new NullPointerException("No null elements accepted");
            }
            if (from < 0) {
                throw new IndexOutOfBoundsException("From index cannot be negative");
            }
            if (to > elements.length + 1) {
                throw new IndexOutOfBoundsException("To index cannot be greater than the array size + 1");
            }
            if (from > to) {
                throw new IllegalArgumentException("From index cannot be greater than the to index");
            }
            this.elements = elements;
            this.from = from;
            this.to = to;
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator<E>(this.elements, this.to, this.from);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayIterator<E>
    implements Iterator<E> {
        private final E[] elements;
        private final int to;
        private int current;

        ArrayIterator(E[] elements, int to, int current) throws NullPointerException, IndexOutOfBoundsException, IllegalArgumentException {
            if (elements == null) {
                throw new NullPointerException("No null elements accepted");
            }
            if (current < 0) {
                throw new IndexOutOfBoundsException("From index cannot be negative");
            }
            if (to > elements.length + 1) {
                throw new IndexOutOfBoundsException("To index cannot be greater than the array size + 1");
            }
            if (current > to) {
                throw new IllegalArgumentException("From index cannot be greater than the to index");
            }
            this.elements = elements;
            this.current = current;
            this.to = to;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.to;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.elements[this.current++];
        }

        @Override
        public void remove() {
            throw new NoSuchElementException();
        }
    }
}

