/*
 * Decompiled with CFR 0.152.
 */
package juzu.io;

import java.io.IOException;
import juzu.impl.common.Tools;
import juzu.io.Stream;

public interface Streamable {
    public void send(Stream var1) throws IOException;

    public static class Bytes
    implements Streamable {
        private final byte[] s;

        public Bytes(byte[] s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Stream stream) throws IOException {
            try {
                stream.append(this.s);
            }
            finally {
                Tools.safeClose(stream);
            }
        }
    }

    public static class InputStream
    implements Streamable {
        private final java.io.InputStream in;

        public InputStream(java.io.InputStream in) {
            this.in = in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Stream stream) throws IOException {
            byte[] buffer = new byte[256];
            try {
                int l;
                while ((l = this.in.read(buffer)) != -1) {
                    stream.append(buffer, 0, l);
                }
            }
            finally {
                Tools.safeClose(stream);
            }
        }
    }

    public static class CharSequence
    implements Streamable {
        private final java.lang.CharSequence s;

        public CharSequence(java.lang.CharSequence s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(Stream stream) throws IOException {
            try {
                stream.append(this.s);
            }
            finally {
                Tools.safeClose(stream);
            }
        }
    }
}

