/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.ajax;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import juzu.PropertyType;
import juzu.asset.AssetLocation;
import juzu.impl.asset.AssetManager;
import juzu.impl.plugin.PluginContext;
import juzu.impl.plugin.PluginDescriptor;
import juzu.impl.plugin.application.ApplicationPlugin;
import juzu.impl.plugin.controller.ControllerPlugin;
import juzu.impl.request.Method;
import juzu.impl.request.Request;
import juzu.impl.request.RequestFilter;
import juzu.io.Chunk;
import juzu.io.Stream;
import juzu.io.Streamable;
import juzu.plugin.ajax.Ajax;
import juzu.request.Phase;
import juzu.request.Result;

public class AjaxPlugin
extends ApplicationPlugin
implements RequestFilter {
    Map<String, Method> table;
    @Inject
    ControllerPlugin controllerPlugin;
    @Inject
    AssetManager manager;

    public AjaxPlugin() {
        super("ajax");
    }

    public PluginDescriptor init(PluginContext context) throws Exception {
        return context.getConfig() != null ? new PluginDescriptor() : null;
    }

    @PostConstruct
    public void start() throws Exception {
        URL url = AjaxPlugin.class.getClassLoader().getResource("juzu/impl/plugin/ajax/script.js");
        if (url == null) {
            throw new Exception("Not found script.js");
        }
        this.manager.addAsset("juzu.ajax", AssetLocation.APPLICATION, "/juzu/impl/plugin/ajax/script.js", url, "jquery");
        HashMap<String, Method> table = new HashMap<String, Method>();
        for (Method cm : this.controllerPlugin.getDescriptor().getMethods()) {
            Ajax ajax = cm.getMethod().getAnnotation(Ajax.class);
            if (ajax == null) continue;
            table.put(cm.getName(), cm);
        }
        this.table = table;
    }

    public void invoke(final Request request) {
        Result result;
        request.invoke();
        if (request.getPhase() == Phase.VIEW && (result = request.getResult()) instanceof Result.Status) {
            Result.Status status = (Result.Status)result;
            if (status.decorated) {
                final Streamable wrapped = status.streamable;
                Streamable wrapper = new Streamable(){

                    public void send(final Stream stream) throws IllegalStateException {
                        Stream our = new Stream(){
                            boolean done = false;

                            public void provide(Chunk chunk) {
                                if (chunk instanceof Chunk.Data && !this.done) {
                                    this.done = true;
                                    stream.provide(new Chunk.Property<String>("juzu.ajax", PropertyType.ASSET));
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("<div class=\"jz\">\n");
                                    for (Map.Entry<String, Method> entry : AjaxPlugin.this.table.entrySet()) {
                                        String baseURL = request.createDispatch(entry.getValue()).toString();
                                        sb.append("<div data-method-id=\"");
                                        sb.append(entry.getValue().getId());
                                        sb.append("\" data-url=\"");
                                        sb.append(baseURL);
                                        sb.append("\"/>");
                                        sb.append("</div>");
                                    }
                                    stream.provide(Chunk.create(sb));
                                }
                                stream.provide(chunk);
                            }

                            public void close(Thread.UncaughtExceptionHandler errorHandler) {
                                stream.provide(Chunk.create("</div>"));
                                stream.close(errorHandler);
                            }
                        };
                        wrapped.send(our);
                    }
                };
                request.setResult(new Result.Status(status.code, true, wrapper));
            }
        }
    }
}

