/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.application.descriptor;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import juzu.impl.common.JSON;
import juzu.impl.common.Tools;
import juzu.impl.inject.BeanDescriptor;
import juzu.impl.plugin.PluginDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDescriptor
extends PluginDescriptor {
    private final Class<?> applicationClass;
    private final String packageName;
    private final String name;
    private final Class<?> packageClass;
    private final JSON config;
    private final ClassLoader loader;

    public static ApplicationDescriptor create(ClassLoader loader, String applicationName) throws Exception {
        if (loader == null) {
            throw new NullPointerException("No null loader accepted");
        }
        Class<?> applicationClass = loader.loadClass(applicationName + ".Application");
        return new ApplicationDescriptor(loader, applicationClass);
    }

    public static ApplicationDescriptor create(Class<?> applicationClass) throws Exception {
        return new ApplicationDescriptor(applicationClass.getClassLoader(), applicationClass);
    }

    private ApplicationDescriptor(ClassLoader loader, Class<?> applicationClass) throws Exception {
        JSON config;
        InputStream in = null;
        try {
            String configPath = applicationClass.getPackage().getName().replace('.', '/') + "/config.json";
            in = loader.getResourceAsStream(configPath);
            String s = Tools.read(in);
            config = (JSON)JSON.parse(s);
        }
        catch (IOException e) {
            try {
                throw new AssertionError((Object)e);
            }
            catch (Throwable throwable) {
                Tools.safeClose(in);
                throw throwable;
            }
        }
        Tools.safeClose(in);
        this.applicationClass = applicationClass;
        this.name = applicationClass.getSimpleName();
        this.packageName = applicationClass.getPackage().getName();
        this.packageClass = Tools.getPackageClass(applicationClass.getClassLoader(), applicationClass.getPackage().getName());
        this.loader = loader;
        this.config = config;
    }

    public JSON getConfig() {
        return this.config;
    }

    @Override
    public Iterable<BeanDescriptor> getBeans() {
        return Collections.emptyList();
    }

    public Class<?> getPackageClass() {
        return this.packageClass;
    }

    public Class<?> getApplicationClass() {
        return this.applicationClass;
    }

    public ClassLoader getApplicationLoader() {
        return this.loader;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return this.name;
    }
}

