/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.asset;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import juzu.asset.AssetLocation;
import juzu.impl.asset.Asset;
import juzu.impl.asset.AssetNode;
import juzu.impl.common.Tools;
import juzu.impl.plugin.application.Application;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssetManager {
    protected final LinkedHashMap<String, AssetNode> assets = new LinkedHashMap();
    public final HashMap<String, URL> resources = new HashMap();
    protected final String prefix;
    protected final Application application;

    @Inject
    public AssetManager(Application application) {
        this.prefix = "/" + application.getDescriptor().getPackageName().replace('.', '/') + "/assets/";
        this.application = application;
    }

    public boolean addAsset(String id, String type, AssetLocation location, String value, URL url, String ... dependencies) throws NullPointerException, IllegalArgumentException {
        return this.addAsset(id, type, location, value, url, Tools.set(dependencies));
    }

    public boolean addAsset(String id, String type, AssetLocation location, String value, URL resource, Set<String> dependencies) throws NullPointerException, IllegalArgumentException {
        if (!this.assets.keySet().contains(id)) {
            AssetNode asset = new AssetNode(id, type, location, value, dependencies);
            for (AssetNode deployed : this.assets.values()) {
                if (deployed.iDependOn.contains(id)) {
                    asset.dependsOnMe = Tools.addToHashSet(asset.dependsOnMe, deployed.id);
                }
                if (!asset.iDependOn.contains(deployed.id)) continue;
                deployed.dependsOnMe = Tools.addToHashSet(deployed.dependsOnMe, id);
            }
            this.assets.put(id, asset);
            if (resource != null) {
                this.resources.put(value, resource);
            }
            return true;
        }
        return false;
    }

    public URL resolveURL(Asset asset) {
        switch (asset.getLocation()) {
            case APPLICATION: {
                return this.resources.get(asset.getURI());
            }
        }
        return null;
    }

    public URL resolveURL(AssetLocation location, String path) {
        switch (location) {
            case APPLICATION: {
                URL url = this.resources.get(path);
                if (url == null && path.startsWith(this.prefix)) {
                    url = this.application.getClassLoader().getResource(path.substring(1));
                }
                return url;
            }
        }
        return null;
    }

    public Map<String, Asset> getAssets(String type) {
        Map<String, Asset> ret = Collections.emptyMap();
        for (AssetNode node : this.assets.values()) {
            if (!node.asset.getType().equals(type)) continue;
            if (ret.isEmpty()) {
                ret = new HashMap<String, Asset>();
            }
            ret.put(node.id, node.asset);
        }
        return ret;
    }

    public Asset getAsset(String id) throws NullPointerException {
        if (id == null) {
            throw new NullPointerException("No null id accepted");
        }
        AssetNode node = this.assets.get(id);
        return node != null ? node.asset : null;
    }

    public Iterable<Asset> resolveAssets(Iterable<String> ids) throws NullPointerException, IllegalArgumentException {
        if (ids == null) {
            throw new NullPointerException("No null asset ids accepted");
        }
        LinkedHashMap<String, HashSet<String>> sub = new LinkedHashMap<String, HashSet<String>>();
        LinkedList<String> queue = Tools.addAll(new LinkedList(), ids);
        while (!queue.isEmpty()) {
            String id = (String)queue.removeFirst();
            AssetNode asset = this.assets.get(id);
            if (asset != null) {
                sub.put(asset.id, new HashSet<String>(asset.iDependOn));
                for (String string : asset.iDependOn) {
                    if (sub.containsKey(string)) continue;
                    queue.addLast(string);
                }
                continue;
            }
            throw new IllegalArgumentException("Cannot resolve asset " + id);
        }
        LinkedList<Asset> resolved = new LinkedList<Asset>();
        while (sub.size() > 0) {
            boolean found = false;
            Iterator i = sub.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                if (!((HashSet)entry.getValue()).isEmpty()) continue;
                i.remove();
                AssetNode assetNode = this.assets.get(entry.getKey());
                resolved.add(assetNode.asset);
                for (String dependency : assetNode.dependsOnMe) {
                    HashSet foo = (HashSet)sub.get(dependency);
                    if (foo == null) continue;
                    foo.remove(entry.getKey());
                }
                found = true;
                break;
            }
            if (found) continue;
            StringBuilder sb = new StringBuilder("Cannot satisfy asset dependencies:\n");
            for (Map.Entry entry : sub.entrySet()) {
                sb.append((String)entry.getKey()).append(" -> ").append(entry.getValue());
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return resolved;
    }
}

