/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.plugin.amd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import juzu.impl.common.Tools;
import juzu.impl.plugin.amd.NormalizeJSReader;
import juzu.impl.plugin.asset.Asset;

public class ModuleAsset
extends Asset {
    private final String adapter;
    private final LinkedHashMap<String, String> dependencyMappings;

    public ModuleAsset(Map<String, Serializable> asset, String adapter, List<String> aliases) {
        super("module", asset);
        LinkedHashMap dependencyMappings;
        if (this.depends != null && aliases != null) {
            dependencyMappings = new LinkedHashMap();
            int size = Math.min(this.depends.size(), aliases.size());
            for (int i = 0; i < size; ++i) {
                dependencyMappings.put(this.depends.get(i), aliases.get(i));
            }
        } else {
            dependencyMappings = null;
        }
        this.depends.add("juzu.amd");
        this.adapter = adapter;
        this.dependencyMappings = dependencyMappings;
    }

    @Override
    public InputStream open(URLConnection resource) throws IOException {
        InputStream stream = resource.getInputStream();
        if (this.dependencyMappings != null || this.adapter != null) {
            StringWriter buffer = new StringWriter();
            buffer.append("\ndefine('").append(this.id).append("', [");
            if (this.dependencyMappings != null) {
                this.joinDependencies(buffer);
            }
            buffer.append("], function(");
            if (this.dependencyMappings != null) {
                this.joinParams(buffer);
            }
            buffer.append(") {");
            buffer.append("var define = function() {");
            buffer.append("return arguments[2].apply(this, [");
            if (this.dependencyMappings != null) {
                this.joinParams(buffer);
            }
            buffer.append("]);");
            buffer.append("};");
            buffer.append("\nreturn ");
            int idx = this.adapter != null && !this.adapter.isEmpty() ? this.adapter.indexOf("@{include}") : -1;
            if (idx != -1) {
                buffer.append(this.adapter.substring(0, idx)).append("\n");
            }
            Tools.copy(new NormalizeJSReader(new InputStreamReader(stream)), buffer);
            if (idx != -1) {
                buffer.append(this.adapter.substring(idx + "@{include}".length(), this.adapter.length()));
            }
            buffer.append("\n});");
            return new ByteArrayInputStream(buffer.toString().getBytes());
        }
        return stream;
    }

    private void joinDependencies(Appendable sb) throws IOException {
        Iterator<String> i = this.dependencyMappings.keySet().iterator();
        while (i.hasNext()) {
            sb.append("'").append(i.next()).append("'");
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
    }

    private void joinParams(Appendable sb) throws IOException {
        Iterator<String> i = this.dependencyMappings.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
    }
}

